package jp.agentec.adf.util;

import java.io.IOException;

public class RuntimeUtil {
	public static void exec(String prog) throws IOException {
		Process p = null;
		try {
			p = Runtime.getRuntime().exec(prog);
			p.waitFor();
		} catch (InterruptedException e) {
		} finally {

			try {
				if (p != null) {
					p.getErrorStream().close();
				}
			} catch (Exception e) {
			}

			try {
				if (p != null) {
					p.getInputStream().close();
				}
			} catch (Exception e) {
			}

			try {
				if (p != null) {
					p.getOutputStream().close();
				}
			} catch (Exception e) {
			}

            // TODO 修正履歴メモ
            // 内部エラーログがでるため、コメントアウト
            // 既に上記の処理で破棄されたもよう
//			try {
//				if (p != null) {
//					p.destroy();
//				}
//			} catch (Exception e) {
//			}
		}
	}

    /**
     * ルート化端末チェック
     *
     * @return ルート化端末の場合true, ルート化端末ではない場合falseで返します。
     */
    public static boolean deviceRootCheck() {
        boolean isSuCommand = true;
        try {
            Process process = Runtime.getRuntime().exec("su");
            process.destroy();

        } catch (IOException e) {
            //suコマンドが実行されない場合
            isSuCommand = false;
        }
        return isSuCommand;
    }
}
