package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.type.ContentSortingType;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.data.SortDirection;
import jp.agentec.abook.abv.bl.dto.MydataDto;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentBookmarkDaoTest extends TestCase {

	private ContentBookmarkDao dao = AbstractDao.getDao(ContentBookmarkDao.class);

	public ContentBookmarkDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentBookmarkDaoTest");
		suite.addTest(new ContentBookmarkDaoTest("testGetAllMyDataList"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testGetAllMyDataList() {
		ContentSortingType contentSortingType = ContentSortingType.DownloadDate;
		SortDirection sortDirection = SortDirection.DESC;
		String[] contentTypes = { ContentJSON.PDF_TYPE, ContentJSON.NONE_TYPE };
		List<MydataDto> myDataDtoList = dao.getAllMyDataList(contentSortingType, sortDirection, contentTypes);
		for (MydataDto dto : myDataDtoList) {
			Logger.d(dto.contentName);
			Logger.d(dto.content);
		}
	}

}
