package jp.agentec.abook.abv.bl.data.dao;

import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.json.content.ContentJSON;
import jp.agentec.abook.abv.bl.acms.type.ContentSortingType;
import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.log.LogLevel;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.data.SortDirection;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.ContentPageDto;
import jp.agentec.abook.abv.bl.dto.MydataDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.DateTimeUtil.DateUnit;
import jp.agentec.adf.util.NumericUtil;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentDaoTest extends TestCase {
	
	private long contentId = 1000;
	private int contractContentId = 100;
	private ContentDao dao = AbstractDao.getDao(ContentDao.class);
	
	public ContentDaoTest(String string) {
		super(string);
	}


	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
		
		ABVEnvironment.getInstance().setLogLevel(LogLevel.verbose);
	}
	

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentDaoTest");
//		suite.addTest(new ContentDaoTest("testInsertContent"));
//		suite.addTest(new ContentDaoTest("testGetAllContents"));
//		suite.addTest(new ContentDaoTest("getDownloadedPdf"));
//		suite.addTest(new ContentDaoTest("testUpdateContent"));
//		suite.addTest(new ContentDaoTest("testDeleteContent"));
//		suite.addTest(new ContentDaoTest("testUpdateReadingDateContent"));
//		suite.addTest(new ContentDaoTest("updateLastViewedPage"));
//		suite.addTest(new ContentDaoTest("testGetAllMyDataList"));
//		suite.addTest(new ContentDaoTest("testDownload"));
		suite.addTest(new ContentDaoTest("testGetNewContents"));
		return suite;
	}


	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
//		dao.deleteContent(contentId, true);
	}
	
	public void testInsertContent() throws Exception {
		System.out.println("testInsertContent");
		if (dao.getContent(contentId) != null) return;
		String time = "2013-08-08 15:00:00.0";
		String s = "207,206";
		int groupIds[] = null;
		if (s != null) {
			String[] a = s.split(",");
			groupIds = new int[a.length];
			
			for (int i = 0; i < a.length; i++) {
				groupIds[i] = NumericUtil.parseInt(a[i]);
			}
		}
		
		ContentDto dto = new ContentDto();
		dto.alertMessage="あらーと";
		dto.alertMessageLevel=1;
		dto.allPageNum = 10;
		dto.categoryId=1233;
		dto.contentDetail="しょうさい";
		dto.contentGroups="ぐるーぷ";
		dto.contentId=contentId++;
		dto.contentName="たいとうｒ";
		dto.contentNameKana="...";
		dto.contentProtectedFlg=true;
		dto.contentSize=1024;
		dto.contentType="pdfFile";
		dto.contractContentId = contractContentId++;
		dto.deliveryEndDate= DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
		dto.deliveryStartDate =DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
		dto.detailPageNum = 2;
		dto.downloadedFlg = false;
		dto.downloadingFlg = true;
		dto.status = DownloadStatusType.Canceled.type();
		dto.isChecked = false;
		dto.favoriteFlg = false;
		dto.groupIds = new int[]{100, 200};
		dto.lastDeliveryDate = DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
		dto.metaVersion = 2;
		dto.newFlg = false;
		dto.orientation = 1;
		dto.pagePath = "/data/data/jp.agentec.abook.abv.launcher.android/files/ABook/contents/1062/detail";
		List<ContentPageDto>list = null;
		dto.pages = list;
		dto.printFlg = false;
		dto.readingCount =10;
		dto.readingDate = DateTimeUtil.toDate(time, DateTimeFormat.yyyyMMddHHmmss_hyphen);
		dto.downloadProgress = new Integer(1);
		dto.resourcePath = null;
		dto.resourceVersion = 3;
		dto.tags = new String[3];
		dto.thumbnailBigPath = "";
		dto.thumbnailNormalPath = "";
		dto.updatedFlg = true;
		
		dao.insertContent(dto);
		
		List<ContentDto> dtoList = dao.getAllContents();
		for (ContentDto contentDto : dtoList) {
			System.out.println(contentDto.toString());
		}
//		List<ContentDto> daoList = dao.getConten();
//		for (AppConfigDto appConfigDto : daoList) {
//			System.out.println(appConfigDto.appConfigName + " : " + appConfigDto.val);
//		}
	}
	
	public void testGetAllContents() throws Exception {
		List<ContentDto> dtoList = dao.getAllContents();
		for (ContentDto contentDto : dtoList) {
//			System.out.println(contentDto);
			System.out.println(contentDto.contentId + " : " + contentDto.status  + " : " + contentDto.getDownloadStatus() + " : " + contentDto.downloadProgress + " : " + contentDto.downloadedBytes
					+ " : " + contentDto.downloadStartDate	+ " : " + contentDto.downloadEndDate + " : " + contentDto.logSendedFlg);
		}
	}

	public void testUpdateContent() {
		List<ContentDto> dtoList = dao.getAllContents();
		for (ContentDto contentDto : dtoList) {
			System.out.println(contentDto);
			contentDto.disableAutoDl = false;
			dao.updateContent(contentDto, false);
		}
	}
	
	public void testDeleteContent() {
		List<ContentDto> dtoList = dao.getAllContents();
		for (ContentDto contentDto : dtoList) {
			System.out.println(contentDto);
			dao.deleteContent(contentDto.contentId, false);
		}
	}
	
	public void testUpdateReadingDateContent() throws Exception {
		Long contentId = 1092L;
		Thread.sleep(1000);
		ContentDto dto1 = dao.getContent(contentId);
		System.out.println("dao1:readingDate=" + dto1.readingDate);
		dao.updateContentReadingDate(new Date(System.currentTimeMillis()), contentId);
		
		ContentDto dto2 = dao.getContent(contentId);
		
		assertNotSame(dto1.readingDate, dto2.readingDate);
		System.out.println("dao2:readingDate=" + dto2.readingDate);
	}
	
	public void testUpdateLastViewedPage() throws Exception {
		Long contentId = 1092L;
		ContentDto dto1 = dao.getContent(contentId);
		System.out.println("dao1:page=" + dto1.lastViewedPage);
		dao.updateLastViewedPage(contentId, 5);
		
		ContentDto dto2 = dao.getContent(contentId);
		
		assertNotSame(dto1.lastViewedPage, dto2.lastViewedPage);
		System.out.println("dao2:lastViewedPage=" + dto2.lastViewedPage);
	}
	
	public void testUndeliverableDeleteContent() {
		List<ContentDto> list = dao.getUndeliverableDeleteContent("2013-12-12 00:00:00");
		for (ContentDto contentDto : list) {
			System.out.println(contentDto.contentName);
		}
	}

	public void testGetAllMyDataList() {
		ContentSortingType contentSortingType = ContentSortingType.DownloadDate;
		SortDirection sortDirection = SortDirection.DESC;
		String[] contentTypes = { ContentJSON.PDF_TYPE, ContentJSON.NONE_TYPE };
		List<MydataDto> myDataDtoList = dao.getAllMyDataList(contentSortingType, sortDirection, contentTypes);
		for (MydataDto dto : myDataDtoList) {
			Logger.d(dto.contentName);
			Logger.d(dto.content);
		}
	}
	
	public void getDownloadedPdf() {
		for (Long contentId : dao.getDownloadedPdf()) {
			System.out.println("contentId: " + contentId);
		}
	}
	
	public void testDownload() throws Exception {
		ContentDto dto = new ContentDto();
		dto.contentId = 1001;
		dto.downloadingFlg = false;
		dto.downloadedFlg = false;
		dto.downloadProgress = 10;
		dto.downloadedBytes = 998877;
		dto.downloadStartDate = new Date();
		dto.status = DownloadStatusType.Downloading.type();
		dto.downloadEndDate = DateTimeUtil.add(new Date(), DateUnit.Hour, 3);
		dao.updateDownload(dto);
		
		testGetAllContents();
		
		dto.logSendedFlg = false;
		dao.updateLogSendFlg(dto);
		
		testGetAllContents();
		
//		dao.updateContent(1000, DownloadStatusType.Canceled);
//		dao.updateContent(1000, DownloadStatusType.Failed);
//		dao.updateContent(1000, DownloadStatusType.Successed);
//		testGetAllContents();
		
		
		for (ContentDto contentDto : dao.getSendLog()) {
			System.out.println("getSendLog " + contentDto.contentId);
		}
		
		for (ContentDto contentDto : dao.getDownloadWaiting(1)) {
			System.out.println("getDownloadWaiting " + contentDto.contentId);
		}
		
		for (ContentDto contentDto : dao.getUnfinishedDownloadAll()) {
			System.out.println("getUnfinishedDownloadAll " + contentDto.contentId);
		}
		
	}
	
	public void testGetNewContents() {
		for (ContentDto content : dao.getNewContents(20)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getReadingDateContents(20)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getUpdateContents(20)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getFavoriteContents(20)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getMostviewedContents(20)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getGroupContents(83799)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getCategoryContents(6788)) {
			System.out.println(content.contentName);
		}
		for (ContentDto content : dao.getMyFolderContents(0)) {
			System.out.println(content.contentName);
		}
	}
}
