package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GroupDaoTest extends TestCase {

	private GroupDao dao = AbstractDao.getDao(GroupDao.class);

	public GroupDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("GroupDaoTest");
//		suite.addTest(new GroupDaoTest("testInsertGroup"));
		suite.addTest(new GroupDaoTest("testUpdateGroup"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testInsertGroup() {
		int groupId = 175;
		int parentGroupId = 0;
		String groupName = "全社";
		int groupLevel = 0;
		boolean userGroupFlg = false;

		dao.insertGroup(groupId, parentGroupId, groupName, groupLevel, userGroupFlg);

		int groupId2 = 288;
		int parentGroupId2 = 175;
		String groupName2 = "android";
		int groupLevel2 = 1;
		boolean userGroupFlg2 = false;

		dao.insertGroup(groupId2, parentGroupId2, groupName2, groupLevel2, userGroupFlg2);

		int groupId3 = 258;
		int parentGroupId3 = 288;
		String groupName3 = "TA";
		int groupLevel3 = 2;
		boolean userGroupFlg3 = true;

		dao.insertGroup(groupId3, parentGroupId3, groupName3, groupLevel3, userGroupFlg3);

	}

	public void testUpdateGroup() {
		int groupId = 175;
		int parentGroupId = 0;
		String groupName = "root";
		int groupLevel = 0;
		boolean userGroupFlg = false;

		dao.updateGroup(groupId, parentGroupId, groupName, groupLevel, userGroupFlg);

		int groupId2 = 288;
		int parentGroupId2 = 175;
		String groupName2 = "child01";
		int groupLevel2 = 1;
		boolean userGroupFlg2 = true;

		dao.updateGroup(groupId2, parentGroupId2, groupName2, groupLevel2, userGroupFlg2);

		int groupId3 = 258;
		int parentGroupId3 = 288;
		String groupName3 = "child02";
		int groupLevel3 = 2;
		boolean userGroupFlg3 = false;

		dao.updateGroup(groupId3, parentGroupId3, groupName3, groupLevel3, userGroupFlg3);
	}
}
