package jp.agentec.abook.abv.bl.data.dao;

import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.PasswordLockInfoDto;
import junit.framework.TestCase;

public class PasswordLockInfoDaoTest extends TestCase {
	
	private PasswordLockInfoDao dao = new PasswordLockInfoDao();
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	public void testUpdatePasswordLockInfo() {
		List<PasswordLockInfoDto> list = dao.getPasswordLockInfo();
		PasswordLockInfoDto plidto = null;
		
		for (PasswordLockInfoDto passwordLockInfoDto : list) {
			if (passwordLockInfoDto.id == 1) {
				plidto = passwordLockInfoDto;
				plidto.invalidPasswordCount = (short) (plidto.invalidPasswordCount + 1);
				plidto.passwordLockDate = null;
				dao.updatePasswordLockInfo(plidto);
				break;
			}
		}
	}
}
