package jp.agentec.abook.abv.bl.logic;

import jp.agentec.abook.abv.bl.common.Constant.SignageMode;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ContentReadingLogLogicTest extends TestCase {

	private ContentReadingLogLogic logic = AbstractLogic.getLogic(ContentReadingLogLogic.class);

	public ContentReadingLogLogicTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}
	
	public static TestSuite suite() {
		TestSuite suite = new TestSuite("ContentReadingLogLogicTest");
		suite.addTest(new ContentReadingLogLogicTest("testUpdateLocationContentReadLog"));
//		suite.addTest(new ContentReadingLogLogicTest("requireSendSignageLog"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testUpdateLocationContentReadLog() throws Exception {
		logic.updateLocationContentReadLog(2914, 35.7067932, 139.7732928, SignageMode.SIGNAMGE);
	}
	
	public void requireSendSignageLog() {
		logic.modifyEndSignageLog();
	}
}
