package jp.agentec.abook.abv.ui.viewer.activity;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.viewer.view.AudioPlayView;

import org.json.adf.JSONObject;

import android.content.Intent;
import android.media.AudioManager;
import android.os.Bundle;
import android.view.View;

public class AudioPlayActivity extends NoPdfViewActivity {
    private static final String TAG = "AudioPlayActivity";
    private AudioPlayView audioPlayView;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate:");
        super.onCreate(savedInstanceState);
        
        Intent intent = getIntent();
        String audiofile = intent.getStringExtra(FILEPATH);
        String contentName = intent.getStringExtra(ABookKeys.CONTENT_NAME);
        Logger.d(TAG, "onCreate:" + audiofile);

        setVolumeControlStream(AudioManager.STREAM_MUSIC);
        
        audioPlayView = new AudioPlayView(this, audiofile, contentName, getContentId(), isNormalSize());
        addViewToMainFrame(audioPlayView);
        
        // AudioPlsy側の閉じるボタンを非表示にする
        audioPlayView.findViewById(R.id.imgBtnBack).setVisibility(View.GONE);
    }
	
    @Override
    protected void onPause() {
        super.onPause();
       	audioPlayView.pause();
    }
    
    @Override
    protected void onStop() {
    	super.onStop();
       	audioPlayView.stop();
    }
    
    @Override
    public void performRemoteEvent(JSONObject json) {
		Logger.v(TAG, "[performRemoteEvent] %s", json);
		String type = JsonUtil.getString(json, MeetingManager.TYPE);
		int playTime = JsonUtil.getInt(json, MeetingManager.PLAY_TIME);
		if (playTime != -1 && playTime >= 0 && playTime * 1000 < audioPlayView.getDuration()) {
			audioPlayView.jump(playTime * 1000);
		}
		if (type != null && type.equals(MeetingManager.START)) {
			audioPlayView.restart();
		}
		else if (type != null && type.equals(MeetingManager.PAUSE)) {
			audioPlayView.pause();
		}
	}

}