package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;

import jp.agentec.abook.abv.bl.dto.OperationTaskDto;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * Created by seo-y on 2018/11/15.
 */

public class ActionOperationTaskCode extends TextView {
    public String taskKey;
    private boolean isAnimated = false;
    private Animation animation;
    private Context mContext;
    public OperationTaskDto mOperationTaskDto;

    public ActionOperationTaskCode(Context context, OperationTaskDto dto) {
        super(context);
        mContext = context;
        mOperationTaskDto = dto;
        setSingleLine(true);
        setEllipsize(TextUtils.TruncateAt.END);
        setText(dto.taskCode);
        setTextColor(Color.WHITE);
        setTypeface(null, Typeface.BOLD);
        setTextSize(TypedValue.COMPLEX_UNIT_SP, 14);
        setPadding(15,5,15,5);
        setBackgroundResource(R.drawable.shape_hotspot);
        if (dto.isFinished) {
            setBackgroundColor(OperationTaskLayout.COLOR_BLUE);
        } else {
            setBackgroundColor(OperationTaskLayout.COLOR_ORANGE);
        }
    }

    public void stopAnimation() {
        if (this.isAnimated) {
            this.clearAnimation();
            this.isAnimated = false;
        }
    }

    public void startBlinkAnimation() {
        if (animation == null) {
            animation = new AlphaAnimation(1, 0);
            animation.setDuration(1000);
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE);
            animation.setRepeatMode(Animation.REVERSE);
        }

        this.startAnimation(animation);
        this.isAnimated = true;
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        // アニメーション開始時、viewを描く
        if (this.isAnimated) {
            invalidate();
        }
        super.dispatchDraw(canvas);
    }
}
