/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.util.zip.Deflater;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.Okio;
import oz.lottie.custom.okio.Segment;
import oz.lottie.custom.okio.SegmentPool;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Timeout;
import oz.lottie.custom.okio.Util;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this(Okio.buffer(sink), deflater);
    }

    DeflaterSink(BufferedSink bufferedSink, Deflater deflater) {
        if (bufferedSink == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (deflater == null) {
            throw new IllegalArgumentException("inflater == null");
        }
        this.sink = bufferedSink;
        this.deflater = deflater;
    }

    @Override
    public void write(Buffer buffer, long l) {
        Util.checkOffsetAndCount(buffer.size, 0L, l);
        while (l > 0L) {
            Segment segment = buffer.head;
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            this.deflater.setInput(segment.data, segment.pos, n);
            this.deflate(false);
            buffer.size -= (long)n;
            segment.pos += n;
            if (segment.pos == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.INSTANCE.recycle(segment);
            }
            l -= (long)n;
        }
    }

    private void deflate(boolean bl) {
        Buffer buffer = this.sink.buffer();
        while (true) {
            int n;
            Segment segment = buffer.writableSegment(1);
            int n2 = n = bl ? this.deflater.deflate(segment.data, segment.limit, 2048 - segment.limit, 2) : this.deflater.deflate(segment.data, segment.limit, 2048 - segment.limit);
            if (n > 0) {
                segment.limit += n;
                buffer.size += (long)n;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
    }

    @Override
    public void flush() {
        this.deflate(true);
        this.sink.flush();
    }

    void finishDeflate() {
        this.deflater.finish();
        this.deflate(false);
    }

    @Override
    public void close() {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

