/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.network;

import android.content.Context;
import android.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.ZipInputStream;
import oz.lottie.LottieComposition;
import oz.lottie.LottieCompositionFactory;
import oz.lottie.LottieResult;
import oz.lottie.network.FileExtension;
import oz.lottie.network.NetworkCache;
import oz.lottie.utils.Logger;

public class NetworkFetcher {
    private final Context appContext;
    private final String url;
    private final NetworkCache networkCache;

    public static LottieResult fetchSync(Context context, String string) {
        return new NetworkFetcher(context, string).fetchSync();
    }

    private NetworkFetcher(Context context, String string) {
        this.appContext = context.getApplicationContext();
        this.url = string;
        this.networkCache = new NetworkCache(this.appContext, string);
    }

    public LottieResult fetchSync() {
        LottieComposition lottieComposition = this.fetchFromCache();
        if (lottieComposition != null) {
            return new LottieResult(lottieComposition);
        }
        Logger.debug("Animation for " + this.url + " not found in cache. Fetching from network.");
        return this.fetchFromNetwork();
    }

    private LottieComposition fetchFromCache() {
        Pair pair = this.networkCache.fetch();
        if (pair == null) {
            return null;
        }
        FileExtension fileExtension = (FileExtension)((Object)pair.first);
        InputStream inputStream = (InputStream)pair.second;
        LottieResult lottieResult = fileExtension == FileExtension.ZIP ? LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(inputStream), this.url) : LottieCompositionFactory.fromJsonInputStreamSync(inputStream, this.url);
        if (lottieResult.getValue() != null) {
            return (LottieComposition)lottieResult.getValue();
        }
        return null;
    }

    private LottieResult fetchFromNetwork() {
        try {
            return this.fetchFromNetworkInternal();
        }
        catch (IOException iOException) {
            return new LottieResult(iOException);
        }
    }

    private LottieResult fetchFromNetworkInternal() {
        Logger.debug("Fetching " + this.url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.url).openConnection();
        httpURLConnection.setRequestMethod("GET");
        try {
            httpURLConnection.connect();
            if (httpURLConnection.getErrorStream() != null || httpURLConnection.getResponseCode() != 200) {
                String string = this.getErrorFromConnection(httpURLConnection);
                LottieResult lottieResult = new LottieResult(new IllegalArgumentException("Unable to fetch " + this.url + ". Failed with " + httpURLConnection.getResponseCode() + "\n" + string));
                return lottieResult;
            }
            LottieResult lottieResult = this.getResultFromConnection(httpURLConnection);
            Logger.debug("Completed fetch from network. Success: " + (lottieResult.getValue() != null));
            LottieResult lottieResult2 = lottieResult;
            return lottieResult2;
        }
        catch (Exception exception) {
            LottieResult lottieResult = new LottieResult(exception);
            return lottieResult;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private String getErrorFromConnection(HttpURLConnection httpURLConnection) {
        int n = httpURLConnection.getResponseCode();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append('\n');
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    private LottieResult getResultFromConnection(HttpURLConnection httpURLConnection) {
        FileExtension fileExtension;
        LottieResult lottieResult = null;
        String string = httpURLConnection.getContentType();
        if (string == null) {
            string = "application/json";
        }
        if (string.contains("application/zip")) {
            Logger.debug("Handling zip response.");
            fileExtension = FileExtension.ZIP;
            File file = this.networkCache.writeTempCacheFile(httpURLConnection.getInputStream(), fileExtension);
            lottieResult = LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(new FileInputStream(file)), this.url);
        } else {
            Logger.debug("Received json response.");
            fileExtension = FileExtension.JSON;
            File file = this.networkCache.writeTempCacheFile(httpURLConnection.getInputStream(), fileExtension);
            lottieResult = LottieCompositionFactory.fromJsonInputStreamSync(new FileInputStream(new File(file.getAbsolutePath())), this.url);
        }
        if (lottieResult.getValue() != null) {
            this.networkCache.renameTempFile(fileExtension);
        }
        return lottieResult;
    }
}

