/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Color;
import android.graphics.Rect;
import java.util.ArrayList;
import java.util.Collections;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableTextFrame;
import oz.lottie.model.animatable.AnimatableTextProperties;
import oz.lottie.model.animatable.AnimatableTransform;
import oz.lottie.model.content.Mask;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.Layer$LayerType;
import oz.lottie.model.layer.Layer$MatteType;
import oz.lottie.parser.AnimatableTextPropertiesParser;
import oz.lottie.parser.AnimatableTransformParser;
import oz.lottie.parser.AnimatableValueParser;
import oz.lottie.parser.ContentModelParser;
import oz.lottie.parser.MaskParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.utils.Utils;
import oz.lottie.value.Keyframe;

public class LayerParser {
    private static final JsonReader$Options NAMES = JsonReader$Options.of("nm", "ind", "refId", "ty", "parent", "sw", "sh", "sc", "ks", "tt", "masksProperties", "shapes", "t", "ef", "sr", "st", "w", "h", "ip", "op", "tm", "cl", "hd");
    private static final JsonReader$Options TEXT_NAMES = JsonReader$Options.of("d", "a");
    private static final JsonReader$Options EFFECTS_NAMES = JsonReader$Options.of("nm");

    private LayerParser() {
    }

    public static Layer parse(LottieComposition lottieComposition) {
        Rect rect = lottieComposition.getBounds();
        return new Layer(Collections.emptyList(), lottieComposition, "__container", -1L, Layer$LayerType.PRE_COMP, -1L, null, Collections.emptyList(), new AnimatableTransform(), 0, 0, 0, 0.0f, 0.0f, rect.width(), rect.height(), null, null, Collections.emptyList(), Layer$MatteType.NONE, null, false);
    }

    public static Layer parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        Object object;
        String string = "UNSET";
        Layer$LayerType layer$LayerType = null;
        String string2 = null;
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l2 = -1L;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string3 = null;
        boolean bl = false;
        Layer$MatteType layer$MatteType = Layer$MatteType.NONE;
        AnimatableTransform animatableTransform = null;
        AnimatableTextFrame animatableTextFrame = null;
        AnimatableTextProperties animatableTextProperties = null;
        AnimatableFloatValue animatableFloatValue = null;
        ArrayList<Mask> arrayList = new ArrayList<Mask>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    string = jsonReader.nextString();
                    break;
                }
                case 1: {
                    l = jsonReader.nextInt();
                    break;
                }
                case 2: {
                    string2 = jsonReader.nextString();
                    break;
                }
                case 3: {
                    int n6 = jsonReader.nextInt();
                    if (n6 < Layer$LayerType.UNKNOWN.ordinal()) {
                        layer$LayerType = Layer$LayerType.values()[n6];
                        break;
                    }
                    layer$LayerType = Layer$LayerType.UNKNOWN;
                    break;
                }
                case 4: {
                    l2 = jsonReader.nextInt();
                    break;
                }
                case 5: {
                    n = (int)((float)jsonReader.nextInt() * Utils.dpScale());
                    break;
                }
                case 6: {
                    n2 = (int)((float)jsonReader.nextInt() * Utils.dpScale());
                    break;
                }
                case 7: {
                    n3 = Color.parseColor((String)jsonReader.nextString());
                    break;
                }
                case 8: {
                    animatableTransform = AnimatableTransformParser.parse(jsonReader, lottieComposition);
                    break;
                }
                case 9: {
                    layer$MatteType = Layer$MatteType.values()[jsonReader.nextInt()];
                    lottieComposition.incrementMatteOrMaskCount(1);
                    break;
                }
                case 10: {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        arrayList.add(MaskParser.parse(jsonReader, lottieComposition));
                    }
                    lottieComposition.incrementMatteOrMaskCount(arrayList.size());
                    jsonReader.endArray();
                    break;
                }
                case 11: {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        object = ContentModelParser.parse(jsonReader, lottieComposition);
                        if (object == null) continue;
                        arrayList2.add(object);
                    }
                    jsonReader.endArray();
                    break;
                }
                case 12: {
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        switch (jsonReader.selectName(TEXT_NAMES)) {
                            case 0: {
                                animatableTextFrame = AnimatableValueParser.parseDocumentData(jsonReader, lottieComposition);
                                break;
                            }
                            case 1: {
                                jsonReader.beginArray();
                                if (jsonReader.hasNext()) {
                                    animatableTextProperties = AnimatableTextPropertiesParser.parse(jsonReader, lottieComposition);
                                }
                                while (jsonReader.hasNext()) {
                                    jsonReader.skipValue();
                                }
                                jsonReader.endArray();
                                break;
                            }
                            default: {
                                jsonReader.skipName();
                                jsonReader.skipValue();
                            }
                        }
                    }
                    jsonReader.endObject();
                    break;
                }
                case 13: {
                    jsonReader.beginArray();
                    object = new ArrayList();
                    while (jsonReader.hasNext()) {
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            switch (jsonReader.selectName(EFFECTS_NAMES)) {
                                case 0: {
                                    object.add(jsonReader.nextString());
                                    break;
                                }
                                default: {
                                    jsonReader.skipName();
                                    jsonReader.skipValue();
                                }
                            }
                        }
                        jsonReader.endObject();
                    }
                    jsonReader.endArray();
                    lottieComposition.addWarning("Lottie doesn't support layer effects. If you are using them for  fills, strokes, trim paths etc. then try adding them directly as contents  in your shape. Found: " + object);
                    break;
                }
                case 14: {
                    f2 = (float)jsonReader.nextDouble();
                    break;
                }
                case 15: {
                    f3 = (float)jsonReader.nextDouble();
                    break;
                }
                case 16: {
                    n4 = (int)((float)jsonReader.nextInt() * Utils.dpScale());
                    break;
                }
                case 17: {
                    n5 = (int)((float)jsonReader.nextInt() * Utils.dpScale());
                    break;
                }
                case 18: {
                    f4 = (float)jsonReader.nextDouble();
                    break;
                }
                case 19: {
                    f5 = (float)jsonReader.nextDouble();
                    break;
                }
                case 20: {
                    animatableFloatValue = AnimatableValueParser.parseFloat(jsonReader, lottieComposition, false);
                    break;
                }
                case 21: {
                    string3 = jsonReader.nextString();
                    break;
                }
                case 22: {
                    bl = jsonReader.nextBoolean();
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
        f4 /= f2;
        f5 /= f2;
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (f4 > 0.0f) {
            object = new Keyframe(lottieComposition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(f4));
            arrayList3.add(object);
        }
        f5 = f5 > 0.0f ? f5 : lottieComposition.getEndFrame();
        object = new Keyframe(lottieComposition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, f4, Float.valueOf(f5));
        arrayList3.add(object);
        Keyframe keyframe = new Keyframe(lottieComposition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, f5, Float.valueOf(Float.MAX_VALUE));
        arrayList3.add(keyframe);
        if (string.endsWith(".ai") || "ai".equals(string3)) {
            lottieComposition.addWarning("Convert your Illustrator layers to shape layers.");
        }
        return new Layer(arrayList2, lottieComposition, string, l, layer$LayerType, l2, string2, arrayList, animatableTransform, n, n2, n3, f2, f3, n4, n5, animatableTextFrame, animatableTextProperties, arrayList3, layer$MatteType, animatableFloatValue, bl);
    }
}

