/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Arrays;
import oz.util.barcode.oned.CodaBarReader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class CodaBarWriter
extends OneDimensionalCodeWriter {
    private static final char[] START_END_CHARS = new char[]{'A', 'B', 'C', 'D'};
    private static final char[] ALT_START_END_CHARS = new char[]{'T', 'N', '*', 'E'};
    private static final char[] CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED = new char[]{'/', ':', '+', '.'};

    @Override
    public boolean[] encode(String string) {
        boolean bl;
        if (string.length() < 2) {
            throw new IllegalArgumentException("Codabar should start/end with start/stop symbols");
        }
        char c2 = Character.toUpperCase(string.charAt(0));
        char c3 = Character.toUpperCase(string.charAt(string.length() - 1));
        boolean bl2 = CodaBarReader.arrayContains(START_END_CHARS, c2) && CodaBarReader.arrayContains(START_END_CHARS, c3);
        boolean bl3 = bl = CodaBarReader.arrayContains(ALT_START_END_CHARS, c2) && CodaBarReader.arrayContains(ALT_START_END_CHARS, c3);
        if (!bl2 && !bl) {
            throw new IllegalArgumentException("Codabar should start/end with " + Arrays.toString(START_END_CHARS) + ", or start/end with " + Arrays.toString(ALT_START_END_CHARS));
        }
        int n = 20;
        int n2 = 1;
        while (n2 < string.length() - 1) {
            if (Character.isDigit(string.charAt(n2)) || string.charAt(n2) == '-' || string.charAt(n2) == '$') {
                n += 9;
            } else if (CodaBarReader.arrayContains(CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED, string.charAt(n2))) {
                n += 10;
            } else {
                throw new IllegalArgumentException("Cannot encode : '" + string.charAt(n2) + '\'');
            }
            ++n2;
        }
        boolean[] blArray = new boolean[n += string.length() - 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < string.length()) {
            char c4 = Character.toUpperCase(string.charAt(n4));
            if (n4 == 0 || n4 == string.length() - 1) {
                switch (c4) {
                    case 'T': {
                        c4 = 'A';
                        break;
                    }
                    case 'N': {
                        c4 = 'B';
                        break;
                    }
                    case '*': {
                        c4 = 'C';
                        break;
                    }
                    case 'E': {
                        c4 = 'D';
                    }
                }
            }
            int n5 = 0;
            int n6 = 0;
            while (n6 < CodaBarReader.ALPHABET.length) {
                if (c4 == CodaBarReader.ALPHABET[n6]) {
                    n5 = CodaBarReader.CHARACTER_ENCODINGS[n6];
                    break;
                }
                ++n6;
            }
            n6 = 1;
            int n7 = 0;
            int n8 = 0;
            while (n8 < 7) {
                blArray[n3] = n6;
                ++n3;
                if ((n5 >> 6 - n8 & 1) == 0 || n7 == 1) {
                    n6 = n6 != 0 ? 0 : 1;
                    ++n8;
                    n7 = 0;
                    continue;
                }
                ++n7;
            }
            if (n4 < string.length() - 1) {
                blArray[n3] = false;
                ++n3;
            }
            ++n4;
        }
        return blArray;
    }
}

