/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.qrcode.detector;

import oz.util.barcode.ResultPoint;

public final class FinderPattern
extends ResultPoint {
    private final float estimatedModuleSize;
    private final int count;

    FinderPattern(float f2, float f3, float f4) {
        this(f2, f3, f4, 1);
    }

    private FinderPattern(float f2, float f3, float f4, int n) {
        super(f2, f3);
        this.estimatedModuleSize = f4;
        this.count = n;
    }

    public float getEstimatedModuleSize() {
        return this.estimatedModuleSize;
    }

    int getCount() {
        return this.count;
    }

    boolean aboutEquals(float f2, float f3, float f4) {
        if (Math.abs(f3 - this.getY()) <= f2 && Math.abs(f4 - this.getX()) <= f2) {
            float f5 = Math.abs(f2 - this.estimatedModuleSize);
            return f5 <= 1.0f || f5 <= this.estimatedModuleSize;
        }
        return false;
    }

    FinderPattern combineEstimate(float f2, float f3, float f4) {
        int n = this.count + 1;
        float f5 = ((float)this.count * this.getX() + f3) / (float)n;
        float f6 = ((float)this.count * this.getY() + f2) / (float)n;
        float f7 = ((float)this.count * this.estimatedModuleSize + f4) / (float)n;
        return new FinderPattern(f5, f6, f7, n);
    }
}

