/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.DngCreator;
import android.media.Image;
import android.media.MediaScannerConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import oz.util.view.camera.Camera2Manager;
import oz.util.view.camera.Camera2Manager$1;
import oz.util.view.camera.Camera2Manager$ImageSaver$1;
import oz.util.view.camera.Camera2Manager$RefCountedAutoCloseable;
import oz.util.view.camera.CameraUtil;

class Camera2Manager$ImageSaver
implements Runnable {
    private final Image mImage;
    private final File mFile;
    private final CaptureResult mCaptureResult;
    private final CameraCharacteristics mCharacteristics;
    private final Context mContext;
    private final Camera2Manager$RefCountedAutoCloseable mReader;

    private Camera2Manager$ImageSaver(Image image, File file, CaptureResult captureResult, CameraCharacteristics cameraCharacteristics, Context context, Camera2Manager$RefCountedAutoCloseable refCountedAutoCloseable) {
        this.mImage = image;
        this.mFile = file;
        this.mCaptureResult = captureResult;
        this.mCharacteristics = cameraCharacteristics;
        this.mContext = context;
        this.mReader = refCountedAutoCloseable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        int n = this.mImage.getFormat();
        switch (n) {
            case 256: {
                ByteBuffer byteBuffer = this.mImage.getPlanes()[0].getBuffer();
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(this.mFile);
                        fileOutputStream.write(byArray);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var8_10 = null;
                        this.mImage.close();
                        Camera2Manager.access$3200(fileOutputStream);
                        break;
                    }
                    Object var8_9 = null;
                    this.mImage.close();
                    Camera2Manager.access$3200(fileOutputStream);
                    break;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.mImage.close();
                    Camera2Manager.access$3200(fileOutputStream);
                    throw throwable;
                }
            }
            case 32: {
                DngCreator dngCreator = new DngCreator(this.mCharacteristics, this.mCaptureResult);
                FileOutputStream fileOutputStream = null;
                try {
                    try {
                        fileOutputStream = new FileOutputStream(this.mFile);
                        dngCreator.writeImage((OutputStream)fileOutputStream, this.mImage);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var10_15 = null;
                        this.mImage.close();
                        Camera2Manager.access$3200(fileOutputStream);
                        break;
                    }
                    Object var10_14 = null;
                    this.mImage.close();
                    Camera2Manager.access$3200(fileOutputStream);
                    break;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    this.mImage.close();
                    Camera2Manager.access$3200(fileOutputStream);
                    throw throwable;
                }
            }
            default: {
                CameraUtil.e("Cannot save image, unexpected image format:" + n);
            }
        }
        this.mReader.close();
        if (bl) {
            MediaScannerConnection.scanFile((Context)this.mContext, (String[])new String[]{this.mFile.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new Camera2Manager$ImageSaver$1(this));
        }
    }

    /* synthetic */ Camera2Manager$ImageSaver(Image image, File file, CaptureResult captureResult, CameraCharacteristics cameraCharacteristics, Context context, Camera2Manager$RefCountedAutoCloseable refCountedAutoCloseable, Camera2Manager$1 camera2Manager$1) {
        this(image, file, captureResult, cameraCharacteristics, context, refCountedAutoCloseable);
    }

    static /* synthetic */ Image access$3400(Camera2Manager$ImageSaver camera2Manager$ImageSaver) {
        return camera2Manager$ImageSaver.mImage;
    }
}

