/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.history.adapter;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import oz.main.OZStorage;
import oz.viewer.ui.history.HistoryNavigationCompData;
import oz.viewer.ui.history.HistoryNavigationData;
import oz.viewer.ui.history.HistoryNavigationManager;
import oz.viewer.ui.history.HistoryNavigationUtil;
import oz.viewer.ui.history.adapter.Adapter;
import oz.viewer.ui.history.adapter.Item;

class RevisionItem
extends Item
implements View.OnClickListener {
    static final int VIEW_ID_DATE = 10001;
    static final int VIEW_ID_USER = 10002;
    static final int VIEW_ID_VERSION = 10003;
    static final int VIEW_ID_CIRCLE = 10004;
    static final int VIEW_ID_ICON = 10005;
    static final int VIEW_ID_ADDRESS = 10006;
    static final int VIEW_ID_REVERT = 10007;

    public RevisionItem(Adapter adapter, HistoryNavigationManager historyNavigationManager, HistoryNavigationData historyNavigationData) {
        super(adapter, historyNavigationManager);
        this.type = 0;
        this.obj = historyNavigationData;
    }

    protected View createView(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setId(10000);
        linearLayout.setOrientation(0);
        linearLayout.setBackgroundDrawable((Drawable)HistoryNavigationUtil.getListViewStateListDrawable(-1, HistoryNavigationUtil.COLOR_LT_LT_GRAY, HistoryNavigationUtil.COLOR_LT_GRAY));
        linearLayout.setGravity(17);
        linearLayout.setOnTouchListener((View.OnTouchListener)this.getAdapter().mTouchListener);
        FrameLayout frameLayout = new FrameLayout(context);
        int n = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        frameLayout.setPadding(n, n, n, n);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setOrientation(1);
        linearLayout2.setPadding(0, n, 0, n);
        linearLayout2.setGravity(17);
        TextView textView = new TextView(context);
        textView.setId(10003);
        textView.setSingleLine();
        textView.setTextColor(-1);
        textView.setGravity(17);
        textView.setPadding(0, 0, 0, 0);
        textView.setBackgroundDrawable(null);
        textView.setTextSize(2, 10.0f);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new OvalShape());
        int n2 = n * 2;
        shapeDrawable.setIntrinsicWidth(n2);
        shapeDrawable.setIntrinsicHeight(n2);
        shapeDrawable.setBounds(new Rect(0, 0, n2, n2));
        shapeDrawable.getPaint().setColor(this.getManager().isRevertMode() ? HistoryNavigationUtil.COLOR_LIGHT_GREEN : HistoryNavigationUtil.COLOR_SKY_BLUE);
        ImageView imageView = new ImageView(context);
        imageView.setId(10004);
        imageView.setBackgroundDrawable((Drawable)shapeDrawable);
        frameLayout.addView((View)imageView);
        frameLayout.addView((View)textView);
        TextView textView2 = new TextView(context);
        textView2.setId(10001);
        textView2.setTextColor(HistoryNavigationUtil.COLOR_DK_DK_GRAY);
        textView2.setGravity(19);
        textView2.setTextSize(2, 18.0f);
        textView2.setPadding(0, 0, n, 0);
        TextView textView3 = new TextView(context);
        textView3.setId(10002);
        textView3.setTextColor(HistoryNavigationUtil.COLOR_DK_GRAY);
        textView3.setGravity(19);
        textView3.setTextSize(2, 15.0f);
        textView3.setPadding(n, 0, n, 0);
        TextView textView4 = new TextView(context);
        textView4.setId(10006);
        textView4.setTextColor(HistoryNavigationUtil.COLOR_DK_GRAY);
        textView4.setGravity(19);
        textView4.setTextSize(2, 15.0f);
        textView4.setPadding(n, 0, n, 0);
        ImageView imageView2 = new ImageView(context);
        imageView2.setId(10005);
        imageView2.setPadding(0, 0, 0, 0);
        HistoryNavigationUtil.setViewAssetBackground((View)imageView2, "resource/default_btn_next_icon_d@2x.png");
        ImageView imageView3 = new ImageView(context);
        imageView3.setId(10007);
        imageView3.setPadding(0, 0, 0, 0);
        imageView3.setVisibility(8);
        imageView3.setOnClickListener((View.OnClickListener)this);
        HistoryNavigationUtil.setViewAssetBackground((View)imageView3, "resource/revert_40x40.png");
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.width = (int)((float)imageView3.getDrawable().getIntrinsicWidth() * 1.4f * (OZStorage.getDensityDPI() / 2.0f));
        layoutParams.height = (int)((float)imageView3.getDrawable().getIntrinsicHeight() * 1.4f * (OZStorage.getDensityDPI() / 2.0f));
        layoutParams.rightMargin = layoutParams.leftMargin = OZStorage.DpToPx(context, 5.0f, true);
        imageView3.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView((View)textView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)textView3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout2.addView((View)textView4, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        linearLayout.addView((View)imageView3);
        linearLayout.addView((View)imageView2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        return linearLayout;
    }

    protected void updateView(Context context, View view) {
        boolean bl;
        HistoryNavigationData historyNavigationData = (HistoryNavigationData)this.obj;
        TextView textView = (TextView)view.findViewById(10001);
        textView.setText((CharSequence)SimpleDateFormat.getDateTimeInstance(1, 3).format(new Date(historyNavigationData.getRevisionSaveTime())));
        TextView textView2 = (TextView)view.findViewById(10002);
        String string = " ";
        boolean bl2 = !historyNavigationData.getRevisionUserName().isEmpty();
        boolean bl3 = bl = !historyNavigationData.getRevisionUserID().isEmpty();
        if (bl2 && bl) {
            string = String.format("%s (%s)", historyNavigationData.getRevisionUserName(), historyNavigationData.getRevisionUserID());
            textView2.setVisibility(0);
        } else if (bl2 || bl) {
            string = String.format("%s", bl2 ? historyNavigationData.getRevisionUserName() : historyNavigationData.getRevisionUserID());
            textView2.setVisibility(0);
        } else {
            textView2.setVisibility(8);
        }
        textView2.setText((CharSequence)string);
        TextView textView3 = (TextView)view.findViewById(10006);
        String string2 = historyNavigationData.getRevisionAddress();
        if (!string2.isEmpty()) {
            textView3.setVisibility(0);
        } else {
            textView3.setVisibility(8);
        }
        textView3.setText((CharSequence)string2);
        TextView textView4 = (TextView)view.findViewById(10003);
        textView4.setText((CharSequence)String.valueOf(historyNavigationData.getRevisionVersion()));
        View view2 = view.findViewById(10005);
        if (this.getAdapter().isRevisionPhoneMode()) {
            view2.setVisibility(0);
        } else {
            view2.setVisibility(8);
        }
        View view3 = view.findViewById(10000);
        if (historyNavigationData.equals(this.getManager().getRevision(0))) {
            textView.setTextColor(HistoryNavigationUtil.COLOR_SKY_BLUE);
        } else {
            textView.setTextColor(HistoryNavigationUtil.COLOR_DK_DK_GRAY);
        }
        if (!this.getAdapter().isRevisionPhoneMode() && this.getManager().getSelectedRevision() >= 0 && this.getManager().getRevision(this.getManager().getSelectedRevision()).equals(this.obj)) {
            view3.setSelected(true);
        } else {
            view3.setSelected(false);
        }
        View view4 = view.findViewById(10004);
        ((ShapeDrawable)view4.getBackground()).getPaint().setColor(this.getManager().isRevertMode() ? HistoryNavigationUtil.COLOR_LIGHT_GREEN : HistoryNavigationUtil.COLOR_SKY_BLUE);
        view4.invalidate();
        View view5 = view.findViewById(10007);
        if (this.getManager().isRevertMode()) {
            view5.setVisibility(0);
        } else {
            view5.setVisibility(8);
        }
    }

    public void onClick(View view) {
        switch (view.getId()) {
            case 10007: {
                HistoryNavigationData historyNavigationData = (HistoryNavigationData)this.obj;
                SparseIntArray sparseIntArray = HistoryNavigationManager.getItemUniqueZOrders(this.getManager().getItems());
                for (int j = 0; j < sparseIntArray.size(); ++j) {
                    int n;
                    int n2 = sparseIntArray.keyAt(j);
                    ArrayList arrayList = HistoryNavigationManager.findItemsByUniqueZOrder(this.getManager().getItems(), n2);
                    HistoryNavigationCompData historyNavigationCompData = null;
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (((HistoryNavigationCompData)arrayList.get((int)n)).version == historyNavigationData.getRevisionVersion()) {
                            historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(n);
                            break;
                        }
                        if (((HistoryNavigationCompData)arrayList.get((int)n)).version >= historyNavigationData.getRevisionVersion() || historyNavigationCompData != null && historyNavigationCompData.version >= ((HistoryNavigationCompData)arrayList.get((int)n)).version) continue;
                        historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(n);
                    }
                    if (historyNavigationCompData == null) continue;
                    for (n = 0; n < arrayList.size(); ++n) {
                        ((HistoryNavigationCompData)arrayList.get((int)n)).selectedValue2 = historyNavigationCompData.isEqualValue((HistoryNavigationCompData)arrayList.get(n));
                    }
                }
                this.getManager().reqestToast(SimpleDateFormat.getDateTimeInstance(1, 3).format(new Date(historyNavigationData.getRevisionSaveTime())));
                this.getManager().getListView().updateListView();
            }
        }
    }
}

