package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.type.RequirePasswordChangeCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONObject;

/**
 * {@link AcmsClient#requirePasswordChange} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public class RequirePasswordChangeJSON extends AcmsCommonJSON {
	public static final String RequirePasswordChange = "requirePasswordChange";
	
	public RequirePasswordChangeCode requirePasswordChange; // パスワードを変更する必要があるか

	public RequirePasswordChangeJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONValidationException {
		super.parse(json);
		int code = getInt(json, RequirePasswordChangeJSON.RequirePasswordChange);
		requirePasswordChange = RequirePasswordChangeCode.parse(String.valueOf(code));
	}
}
