package jp.agentec.abook.abv.bl.acms.client.json.content;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.adf.util.StringUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class MediaInfoJSON extends AbstractJSON {
	
	public static final int BUTTON_TYPE = 1;
	public static final int VIDEO_TYPE = 2;
	public static final int MUSIC_TYPE = 3;
	public static final int CHANGE_IMAGE_TYPE = 4; // 差し替え画像
	public static final int CHANGE_VIDEO_TYPE = 5; // 差し替え動画
	public static final int TRIGGER_TYPE = 6;
	public static final int RICH_TEXT_TYPE = 7;
	public static final int VIEW3D_TYPE = 8;
	public static final int HTML_TYPE = 9;
	public static final int ENQUETE_TYPE = 11;
	public static final int EXAM_TYPE = 12;
	public static final int QUIZ_TYPE = 13;
	
	public MediaInfoJSON(JSONObject mediaJson) {
		super(mediaJson);
	}
	
	public String getFileName() {
		return root.getString("fileName");
	}
	
	/**
	 * VIDEO_TYPE(2) or MUSIC_TYPE(3):再生用のアイコン
	 * @return
	 */
	public Icon getIconInfo() {
		try {
			return new Icon(root.getJSONObject("icon"));
		} catch (JSONException e) {
		}
		return null;
	}
	
	/**
	 * CHANGE_IMAGE_TYPE(4) or CHANGE_VIDEO_TYPE(5)
	 * @return ターゲットのId
	 */
	public long getTargetId() {
		return root.getLong("id");
	}
	
	/**
	 * CHANGE_IMAGE_TYPE:イメージ差し替え
	 * @return １：イメージタップ時　その他：ボタンタップ時
	 */
	public int getTriggerType() { // -1可
		return JsonUtil.getInt(root, "triggerType");
	}
	
	/**
	 * RICH_TEXT_TYPE(7):HTML情報
	 * @return
	 */
	public String getContentHTML() { // null可
		return JsonUtil.getString(root, "content");
	}
	
	/**
	 * Mediaファイル（差し替え動画や差し替えイメージ）のファイルリストを取得
	 * @return Mediaファイル名のリスト
	 */
	public List<String> getMediaFileNames() {
		List<String> fileNames = new ArrayList<String>();
		JSONArray media = JsonUtil.getJSONArray(root, "media");
		for (int i = 0; i < media.length(); i++) {
			String fileName = JsonUtil.getString(media.getJSONObject(i), "fileName");
			if (StringUtil.isNullOrEmpty(fileName)) {
				Logger.e(getClass().getName(), "No fileName in media [" + i + "]"); // TODO: 例外をスローした方がよいか？
			}
			else {
				fileNames.add(fileName);
			}
		}
		return fileNames;
	}

	public long[] getMediaResourceIds() {
		JSONArray media = JsonUtil.getJSONArray(root, "media");
		long[] resourceIds = new long[media.length()];
		for (int i = 0; i < media.length(); i++) {
			resourceIds[i] = JsonUtil.getLong(media.getJSONObject(i), "resourceId");
		}
		return resourceIds;
	}

	/**
	 * VIEW3D_TYPE:3D
	 * @return 画像数（横）
	 */
	public int getHorizonCount() {
		return root.getInt("horizonCount");
	}
	
	/**
	 * VIEW3D_TYPE:3D
	 * @return 画像数（縦）
	 */
	public int getVerticalCount() {
		return root.getInt("verticalCount");
	}
	
	public static class Icon {
		private JSONObject iconJson;
		private Icon(JSONObject iconJson) {
			this.iconJson = iconJson;
		}
		
		// 1〜200
		public int getScale() {
			return JsonUtil.getInt(iconJson, "scale");
		}
		
		// 1桁：1〜3、2桁：1〜3
		public String getPosition() {
			return iconJson.getString("position");
		}
		
	}
	
	public Long getResourceId() { // -1可
		return JsonUtil.getLong(root, "resourceId");
	}
	
	public Long getMovieResourceId() { // -1可
		return JsonUtil.getLong(root, "movieResourceId");
	}
	
	/**
	 * 1:画像のアスペクト比維持
	 * 0:ボタンに合わせる
	 * @return
	 */
	public int getAspectType() {
		return JsonUtil.getInt(root, "aspectType");
	}
}
