package jp.agentec.abook.abv.bl.acms.type;

public enum ContentReadingStatus {
	/**
	 * 読む
	 * @since 1.0.0
	 */
	reading(0),
	/**
	 * 一時中止
	 * @since 1.0.0
	 */
	suspend(1),
	/**
	 * 読み終わり
	 * @since 1.0.0
	 */
	readed(2),
	/**
	 * 送信失敗(ネットワークエラー以外)
	 * @since 1.1.0
	 */
	sendError(-1);
	
	private int readingStatusStatus;
	
	ContentReadingStatus(int readingStatusStatus) {
		this.readingStatusStatus = readingStatusStatus;
	}
	
	/**
	 * コンテンツ一覧状況のコード番号を返します。
	 * @return　コンテンツ一覧状況のコード番号を返します。
	 * @since 1.0.0
	 */
	public int type() {
		return readingStatusStatus;
	}
}
