package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;
import jp.agentec.adf.util.StringUtil;

public class TMarkingSetting extends SQLiteTableScript {
	private final int DEFALUT_ID_PEN = 0;
	private final int DEFALUT_COLOR_PEN = 0XFF0000;
	private final int DEFALUT_WIDTH_PEN = 10;
	
	private final int DEFALUT_ID_MAKER = 1;
	private final int DEFALUT_COLOR_MAKER = 0XFF0000;
	private final int DEFALUT_WIDTH_MAKER = 25;
	
	private final int DEFALUT_ID_ERASER = 2;
	private final int DEFALUT_COLOR_ERASER = -1;
	private final int DEFALUT_WIDTH_ERASER = 50;
	
	
	public TMarkingSetting() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.5.0
		sql.append(" CREATE TABLE t_marking_setting ( ");
		sql.append("        marking_setting_id INTEGER NOT NULL ");
		sql.append("      , color INTEGER ");
		sql.append("      , width INTEGER ");
		sql.append("      , insert_date DATETIME NOT NULL ");
		sql.append("      , update_date DATETIME NOT NULL ");
		sql.append("      , PRIMARY KEY (marking_setting_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		sql.append(" INSERT INTO t_marking_setting (marking_setting_id, color, width, insert_date, update_date) ");
		sql.append(makeValueState(DEFALUT_ID_PEN, DEFALUT_COLOR_PEN, DEFALUT_WIDTH_PEN));
		
		ddl.add(sql.toString());
		
		StringUtil.clear(sql);

		sql.append(" INSERT INTO t_marking_setting (marking_setting_id, color, width, insert_date, update_date) ");
		sql.append(makeValueState(DEFALUT_ID_MAKER, DEFALUT_COLOR_MAKER, DEFALUT_WIDTH_MAKER));
		
		ddl.add(sql.toString());

		
		StringUtil.clear(sql);

		sql.append(" INSERT INTO t_marking_setting (marking_setting_id, color, width, insert_date, update_date) ");
		sql.append(makeValueState(DEFALUT_ID_ERASER, DEFALUT_COLOR_ERASER, DEFALUT_WIDTH_ERASER));
		
		ddl.add(sql.toString());
		
		return ddl;
	}
	
	private String makeValueState(int markingSettingId, int color, int width) {
		return " VALUES (" + markingSettingId + ", "+ color +", " + width +  ", DATETIME('NOW'), DATETIME('NOW')) ";
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object... params) {
		return null;
	}

}
