package jp.agentec.abook.abv.bl.dto;

import java.util.List;

/**
 * Created by leej on 2018/08/31.
 */

public class TaskDto extends AbstractDto {

    public String taskKey;
    public Long taskId;
    public Long operationId;
    public String taskCode;
    public Integer taskStatus;
    public String taskHotSpotInfo;
    public String taskName;
    public Integer phaseNo;
    public Integer phaseStatus = 1; //デフォルト値1 (ネットワーク非接続時に報告した場合、1では無い時に編集できないため)
    public Integer processStatus = 0; //デフォルト値0
    public String processKey;
    public List<TaskReportDto> taskReportDtoList;
    public List<TaskReportApprovalDto> taskReportApprovalDtoList;
    public List<TaskDto> phaseList;
    public boolean delFlg;

    public int taskReportId;

    public boolean taskHasAuthority;  // タスク別の権限

    @Override
    public Object[] getInsertValues() {
        return new Object[] { taskKey, taskId, operationId, taskCode, taskStatus, taskHotSpotInfo, taskName, phaseNo, phaseStatus, processKey, processStatus};
    }

    @Override
    public Object[] getUpdateValues() {
        return new Object[] { taskId, operationId, taskCode, taskStatus, taskHotSpotInfo, delFlg, taskName, phaseNo, phaseStatus, processStatus, processKey, taskKey};
    }

    @Override
    public String[] getKeyValues() {
        return new String[] { "" + taskKey };
    }
}
