package jp.agentec.abook.abv.ui.common.constant;


public enum NaviConsts {

	Up(0),
	Down(1),
	Left(2),
	Right(3),
	Alpha(4),
	Alpha_Up(5);

	private final int ABVNavi;
	
	NaviConsts(int ABVNavi) {
		this.ABVNavi = ABVNavi;
	}
	
	/**
	 * 画面移動の番号を返します。
	 * @return　画面移動の番号です。
	 * @since 1.0.0
	 */
	public int type() {
		return ABVNavi;
	}

	/**
	 * 指定した数字に対応するABVNaviConstsの値を返します。
	 * @param ABVNavi 数字のコードです。
	 * @return　指定した数字に対応するABVNaviConstsの値です。
	 * @since 1.0.0
	 */
	public static NaviConsts parse(int ABVNavi) {
		NaviConsts naviConsts;
		
		switch (ABVNavi) {
		case 0:
			naviConsts = NaviConsts.Up;
			break;
		case 1:
			naviConsts = NaviConsts.Down;
			break;
		case 2:
			naviConsts = NaviConsts.Left;
			break;
		case 3:
			naviConsts = NaviConsts.Right;
			break;
		case 4:
			naviConsts = NaviConsts.Alpha;
			break;
		case 5:
		default:
			naviConsts = NaviConsts.Alpha_Up;
			break;
		}
		
		return naviConsts;
	}
	
}
