/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.view.animation.Interpolator;

class PathInterpolatorApi14
implements Interpolator {
    private static final float PRECISION = 0.002f;
    private final float[] mX;
    private final float[] mY;

    PathInterpolatorApi14(Path path) {
        PathMeasure pathMeasure = new PathMeasure(path, false);
        float f2 = pathMeasure.getLength();
        int n = (int)(f2 / 0.002f) + 1;
        this.mX = new float[n];
        this.mY = new float[n];
        float[] fArray = new float[2];
        int n2 = 0;
        while (n2 < n) {
            float f3 = (float)n2 * f2 / (float)(n - 1);
            pathMeasure.getPosTan(f3, fArray, null);
            this.mX[n2] = fArray[0];
            this.mY[n2] = fArray[1];
            ++n2;
        }
    }

    PathInterpolatorApi14(float f2, float f3) {
        this(PathInterpolatorApi14.createQuad(f2, f3));
    }

    PathInterpolatorApi14(float f2, float f3, float f4, float f5) {
        this(PathInterpolatorApi14.createCubic(f2, f3, f4, f5));
    }

    public float getInterpolation(float f2) {
        if (f2 <= 0.0f) {
            return 0.0f;
        }
        if (f2 >= 1.0f) {
            return 1.0f;
        }
        int n = 0;
        int n2 = this.mX.length - 1;
        while (n2 - n > 1) {
            int n3 = (n + n2) / 2;
            if (f2 < this.mX[n3]) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        float f3 = this.mX[n2] - this.mX[n];
        if (f3 == 0.0f) {
            return this.mY[n];
        }
        float f4 = f2 - this.mX[n];
        float f5 = f4 / f3;
        float f6 = this.mY[n];
        float f7 = this.mY[n2];
        return f6 + f5 * (f7 - f6);
    }

    private static Path createQuad(float f2, float f3) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(f2, f3, 1.0f, 1.0f);
        return path;
    }

    private static Path createCubic(float f2, float f3, float f4, float f5) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(f2, f3, f4, f5, 1.0f, 1.0f);
        return path;
    }
}

