/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser.moshi;

import java.io.Closeable;
import java.util.Arrays;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.BufferedSource;
import oz.lottie.parser.moshi.JsonDataException;
import oz.lottie.parser.moshi.JsonEncodingException;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.parser.moshi.JsonReader$Token;
import oz.lottie.parser.moshi.JsonScope;
import oz.lottie.parser.moshi.JsonUtf8Reader;

public abstract class JsonReader
implements Closeable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    int stackSize;
    int[] scopes = new int[32];
    String[] pathNames = new String[32];
    int[] pathIndices = new int[32];
    boolean lenient;
    boolean failOnUnknown;

    static {
        int n = 0;
        while (n <= 31) {
            JsonReader.REPLACEMENT_CHARS[n] = String.format("\\u%04x", n);
            ++n;
        }
        JsonReader.REPLACEMENT_CHARS[34] = "\\\"";
        JsonReader.REPLACEMENT_CHARS[92] = "\\\\";
        JsonReader.REPLACEMENT_CHARS[9] = "\\t";
        JsonReader.REPLACEMENT_CHARS[8] = "\\b";
        JsonReader.REPLACEMENT_CHARS[10] = "\\n";
        JsonReader.REPLACEMENT_CHARS[13] = "\\r";
        JsonReader.REPLACEMENT_CHARS[12] = "\\f";
    }

    public static JsonReader of(BufferedSource bufferedSource) {
        return new JsonUtf8Reader(bufferedSource);
    }

    JsonReader() {
    }

    final void pushScope(int n) {
        if (this.stackSize == this.scopes.length) {
            if (this.stackSize == 256) {
                throw new JsonDataException("Nesting too deep at " + this.getPath());
            }
            this.scopes = Arrays.copyOf(this.scopes, this.scopes.length * 2);
            this.pathNames = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            this.pathIndices = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
        }
        this.scopes[this.stackSize++] = n;
    }

    final JsonEncodingException syntaxError(String string) {
        throw new JsonEncodingException(String.valueOf(string) + " at path " + this.getPath());
    }

    public abstract void beginArray();

    public abstract void endArray();

    public abstract void beginObject();

    public abstract void endObject();

    public abstract boolean hasNext();

    public abstract JsonReader$Token peek();

    public abstract String nextName();

    public abstract int selectName(JsonReader$Options var1);

    public abstract void skipName();

    public abstract String nextString();

    public abstract boolean nextBoolean();

    public abstract double nextDouble();

    public abstract int nextInt();

    public abstract void skipValue();

    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }

    private static void string(BufferedSink bufferedSink, String string) {
        String[] stringArray = REPLACEMENT_CHARS;
        bufferedSink.writeByte(34);
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            block8: {
                String string2;
                block7: {
                    char c2;
                    block9: {
                        block6: {
                            c2 = string.charAt(n3);
                            if (c2 >= '\u0080') break block6;
                            string2 = stringArray[c2];
                            if (string2 != null) break block7;
                            break block8;
                        }
                        if (c2 != '\u2028') break block9;
                        string2 = "\\u2028";
                        break block7;
                    }
                    if (c2 != '\u2029') break block8;
                    string2 = "\\u2029";
                }
                if (n < n3) {
                    bufferedSink.writeUtf8(string, n, n3);
                }
                bufferedSink.writeUtf8(string2);
                n = n3 + 1;
            }
            ++n3;
        }
        if (n < n2) {
            bufferedSink.writeUtf8(string, n, n2);
        }
        bufferedSink.writeByte(34);
    }

    static /* synthetic */ void access$0(BufferedSink bufferedSink, String string) {
        JsonReader.string(bufferedSink, string);
    }
}

