/*
 * Decompiled with CFR 0.152.
 */
package oz.materialcalendarview;

import android.graphics.drawable.Drawable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oz.materialcalendarview.DayViewFacade$Span;

public class DayViewFacade {
    private boolean isDecorated = false;
    private Drawable backgroundDrawable = null;
    private Drawable selectionDrawable = null;
    private final LinkedList spans = new LinkedList();
    private boolean daysDisabled = false;

    DayViewFacade() {
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.backgroundDrawable = drawable2;
        this.isDecorated = true;
    }

    public void setSelectionDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.selectionDrawable = drawable2;
        this.isDecorated = true;
    }

    public void addSpan(Object object) {
        if (this.spans != null) {
            this.spans.add(new DayViewFacade$Span(object));
            this.isDecorated = true;
        }
    }

    public void setDaysDisabled(boolean bl) {
        this.daysDisabled = bl;
        this.isDecorated = true;
    }

    void reset() {
        this.backgroundDrawable = null;
        this.selectionDrawable = null;
        this.spans.clear();
        this.isDecorated = false;
        this.daysDisabled = false;
    }

    void applyTo(DayViewFacade dayViewFacade) {
        if (this.selectionDrawable != null) {
            dayViewFacade.setSelectionDrawable(this.selectionDrawable);
        }
        if (this.backgroundDrawable != null) {
            dayViewFacade.setBackgroundDrawable(this.backgroundDrawable);
        }
        dayViewFacade.spans.addAll(this.spans);
        dayViewFacade.isDecorated |= this.isDecorated;
        dayViewFacade.daysDisabled = this.daysDisabled;
    }

    boolean isDecorated() {
        return this.isDecorated;
    }

    Drawable getSelectionDrawable() {
        return this.selectionDrawable;
    }

    Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    List getSpans() {
        return Collections.unmodifiableList(this.spans);
    }

    public boolean areDaysDisabled() {
        return this.daysDisabled;
    }
}

