/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oz.util.barcode.DecodeHintType;

final class DecodeHintManager {
    private static final String TAG = DecodeHintManager.class.getSimpleName();
    private static final Pattern COMMA = Pattern.compile(",");

    private DecodeHintManager() {
    }

    private static Map splitQuery(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < string.length()) {
            String string2;
            String string3;
            if (string.charAt(n) == '&') {
                ++n;
                continue;
            }
            int n2 = string.indexOf(38, n);
            int n3 = string.indexOf(61, n);
            if (n2 < 0) {
                if (n3 < 0) {
                    string3 = string.substring(n);
                    string3 = string3.replace('+', ' ');
                    string3 = Uri.decode((String)string3);
                    string2 = "";
                } else {
                    string3 = string.substring(n, n3);
                    string3 = string3.replace('+', ' ');
                    string3 = Uri.decode((String)string3);
                    string2 = string.substring(n3 + 1);
                    string2 = string2.replace('+', ' ');
                    string2 = Uri.decode((String)string2);
                }
                if (hashMap.containsKey(string3)) break;
                hashMap.put(string3, string2);
                break;
            }
            if (n3 < 0 || n3 > n2) {
                string3 = string.substring(n, n2);
                string3 = string3.replace('+', ' ');
                if (!hashMap.containsKey(string3 = Uri.decode((String)string3))) {
                    hashMap.put(string3, "");
                }
                n = n2 + 1;
                continue;
            }
            string3 = string.substring(n, n3);
            string3 = string3.replace('+', ' ');
            string3 = Uri.decode((String)string3);
            string2 = string.substring(n3 + 1, n2);
            string2 = string2.replace('+', ' ');
            string2 = Uri.decode((String)string2);
            if (!hashMap.containsKey(string3)) {
                hashMap.put(string3, string2);
            }
            n = n2 + 1;
        }
        return hashMap;
    }

    static Map parseDecodeHints(Uri uri) {
        String string = uri.getEncodedQuery();
        if (string == null || string.length() == 0) {
            return null;
        }
        Map map = DecodeHintManager.splitQuery(string);
        EnumMap<DecodeHintType, Object> enumMap = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        for (DecodeHintType decodeHintType : DecodeHintType.values()) {
            String string2;
            String string3;
            if (decodeHintType == DecodeHintType.CHARACTER_SET || decodeHintType == DecodeHintType.NEED_RESULT_POINT_CALLBACK || decodeHintType == DecodeHintType.POSSIBLE_FORMATS || (string3 = (String)map.get(string2 = decodeHintType.name())) == null) continue;
            if (decodeHintType.getValueType().equals(Object.class)) {
                enumMap.put(decodeHintType, string3);
                continue;
            }
            if (decodeHintType.getValueType().equals(Void.class)) {
                enumMap.put(decodeHintType, Boolean.TRUE);
                continue;
            }
            if (decodeHintType.getValueType().equals(String.class)) {
                enumMap.put(decodeHintType, string3);
                continue;
            }
            if (decodeHintType.getValueType().equals(Boolean.class)) {
                if (string3.length() == 0) {
                    enumMap.put(decodeHintType, Boolean.TRUE);
                    continue;
                }
                if ("0".equals(string3) || "false".equalsIgnoreCase(string3) || "no".equalsIgnoreCase(string3)) {
                    enumMap.put(decodeHintType, Boolean.FALSE);
                    continue;
                }
                enumMap.put(decodeHintType, Boolean.TRUE);
                continue;
            }
            if (decodeHintType.getValueType().equals(int[].class)) {
                if (string3.length() > 0 && string3.charAt(string3.length() - 1) == ',') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String[] stringArray = COMMA.split(string3);
                int[] nArray = new int[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    try {
                        nArray[j] = Integer.parseInt(stringArray[j]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w((String)TAG, (String)("Skipping array of integers hint " + (Object)((Object)decodeHintType) + " due to invalid numeric value: '" + stringArray[j] + '\''));
                        nArray = null;
                        break;
                    }
                }
                if (nArray == null) continue;
                enumMap.put(decodeHintType, nArray);
                continue;
            }
            Log.w((String)TAG, (String)("Unsupported hint type '" + (Object)((Object)decodeHintType) + "' of type " + decodeHintType.getValueType()));
        }
        Log.i((String)TAG, (String)("Hints from the URI: " + enumMap));
        return enumMap;
    }

    static Map parseDecodeHints(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        EnumMap<DecodeHintType, Object> enumMap = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        for (DecodeHintType decodeHintType : DecodeHintType.values()) {
            String string;
            if (decodeHintType == DecodeHintType.CHARACTER_SET || decodeHintType == DecodeHintType.NEED_RESULT_POINT_CALLBACK || decodeHintType == DecodeHintType.POSSIBLE_FORMATS || !bundle.containsKey(string = decodeHintType.name())) continue;
            if (decodeHintType.getValueType().equals(Void.class)) {
                enumMap.put(decodeHintType, Boolean.TRUE);
                continue;
            }
            Object object = bundle.get(string);
            if (decodeHintType.getValueType().isInstance(object)) {
                enumMap.put(decodeHintType, object);
                continue;
            }
            Log.w((String)TAG, (String)("Ignoring hint " + (Object)((Object)decodeHintType) + " because it is not assignable from " + object));
        }
        Log.i((String)TAG, (String)("Hints from the Intent: " + enumMap));
        return enumMap;
    }
}

