/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.AddressBookAUResultParser;
import oz.util.barcode.client.result.AddressBookDoCoMoResultParser;
import oz.util.barcode.client.result.BizcardResultParser;
import oz.util.barcode.client.result.BookmarkDoCoMoResultParser;
import oz.util.barcode.client.result.EmailAddressResultParser;
import oz.util.barcode.client.result.EmailDoCoMoResultParser;
import oz.util.barcode.client.result.ExpandedProductResultParser;
import oz.util.barcode.client.result.GeoResultParser;
import oz.util.barcode.client.result.ISBNResultParser;
import oz.util.barcode.client.result.ParsedResult;
import oz.util.barcode.client.result.ProductResultParser;
import oz.util.barcode.client.result.SMSMMSResultParser;
import oz.util.barcode.client.result.SMSTOMMSTOResultParser;
import oz.util.barcode.client.result.SMTPResultParser;
import oz.util.barcode.client.result.TelResultParser;
import oz.util.barcode.client.result.TextParsedResult;
import oz.util.barcode.client.result.URIResultParser;
import oz.util.barcode.client.result.URLTOResultParser;
import oz.util.barcode.client.result.VCardResultParser;
import oz.util.barcode.client.result.VEventResultParser;
import oz.util.barcode.client.result.WifiResultParser;

public abstract class ResultParser {
    private static final ResultParser[] PARSERS = new ResultParser[]{new BookmarkDoCoMoResultParser(), new AddressBookDoCoMoResultParser(), new EmailDoCoMoResultParser(), new AddressBookAUResultParser(), new VCardResultParser(), new BizcardResultParser(), new VEventResultParser(), new EmailAddressResultParser(), new SMTPResultParser(), new TelResultParser(), new SMSMMSResultParser(), new SMSTOMMSTOResultParser(), new GeoResultParser(), new WifiResultParser(), new URLTOResultParser(), new URIResultParser(), new ISBNResultParser(), new ProductResultParser(), new ExpandedProductResultParser()};
    private static final Pattern DIGITS = Pattern.compile("\\d*");
    private static final Pattern ALPHANUM = Pattern.compile("[a-zA-Z0-9]*");
    private static final Pattern AMPERSAND = Pattern.compile("&");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final String BYTE_ORDER_MARK = "\ufeff";

    public abstract ParsedResult parse(Result var1);

    protected static String getMassagedText(Result result) {
        String string = result.getText();
        if (string.startsWith(BYTE_ORDER_MARK)) {
            string = string.substring(1);
        }
        return string;
    }

    public static ParsedResult parseResult(Result result) {
        ResultParser[] resultParserArray = PARSERS;
        int n = PARSERS.length;
        int n2 = 0;
        while (n2 < n) {
            ResultParser resultParser = resultParserArray[n2];
            ParsedResult parsedResult = resultParser.parse(result);
            if (parsedResult != null) {
                return parsedResult;
            }
            ++n2;
        }
        return new TextParsedResult(result.getText(), null);
    }

    protected static void maybeAppend(String string, StringBuilder stringBuilder) {
        if (string != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
        }
    }

    protected static void maybeAppend(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                stringBuilder.append('\n');
                stringBuilder.append(string);
                ++n2;
            }
        }
    }

    protected static String[] maybeWrap(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        return stringArray;
    }

    protected static String unescapeBackslash(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 - 1);
        stringBuilder.append(string.toCharArray(), 0, n);
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (bl || c2 != '\\') {
                stringBuilder.append(c2);
                bl = false;
            } else {
                bl = true;
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    protected static int parseHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return 10 + (c2 - 97);
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return 10 + (c2 - 65);
        }
        return -1;
    }

    protected static boolean isStringOfDigits(CharSequence charSequence, int n) {
        return charSequence != null && n == charSequence.length() && DIGITS.matcher(charSequence).matches();
    }

    protected static boolean isSubstringOfDigits(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return false;
        }
        int n3 = n + n2;
        return charSequence.length() >= n3 && DIGITS.matcher(charSequence.subSequence(n, n3)).matches();
    }

    protected static boolean isSubstringOfAlphaNumeric(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return false;
        }
        int n3 = n + n2;
        return charSequence.length() >= n3 && ALPHANUM.matcher(charSequence.subSequence(n, n3)).matches();
    }

    static Map parseNameValuePairs(String string) {
        int n = string.indexOf(63);
        if (n < 0) {
            return null;
        }
        HashMap hashMap = new HashMap(3);
        String[] stringArray = AMPERSAND.split(string.substring(n + 1));
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            ResultParser.appendKeyValue(string2, hashMap);
            ++n3;
        }
        return hashMap;
    }

    private static void appendKeyValue(CharSequence charSequence, Map map) {
        String[] stringArray = EQUALS.split(charSequence, 2);
        if (stringArray.length == 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            try {
                string2 = ResultParser.urlDecode(string2);
                map.put(string, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    static String[] matchPrefixedField(String string, String string2, char c2, boolean bl) {
        ArrayList<String> arrayList = null;
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            if ((n = string2.indexOf(string, n)) < 0) break;
            int n3 = n += string.length();
            boolean bl2 = true;
            while (bl2) {
                if ((n = string2.indexOf(c2, n)) < 0) {
                    n = string2.length();
                    bl2 = false;
                    continue;
                }
                if (string2.charAt(n - 1) == '\\') {
                    ++n;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(3);
                }
                String string3 = ResultParser.unescapeBackslash(string2.substring(n3, n));
                if (bl) {
                    string3 = string3.trim();
                }
                if (string3.length() > 0) {
                    arrayList.add(string3);
                }
                ++n;
                bl2 = false;
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String matchSinglePrefixedField(String string, String string2, char c2, boolean bl) {
        String[] stringArray = ResultParser.matchPrefixedField(string, string2, c2, bl);
        return stringArray == null ? null : stringArray[0];
    }
}

