/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.detector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DetectorResult;
import oz.util.barcode.common.GridSampler;
import oz.util.barcode.common.detector.MathUtils;
import oz.util.barcode.common.detector.WhiteRectangleDetector;
import oz.util.barcode.datamatrix.detector.Detector$ResultPointsAndTransitions;
import oz.util.barcode.datamatrix.detector.Detector$ResultPointsAndTransitionsComparator;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
        this.rectangleDetector = new WhiteRectangleDetector(bitMatrix);
    }

    public DetectorResult detect() {
        BitMatrix bitMatrix;
        Object object;
        Object object2;
        ResultPoint resultPoint;
        ResultPoint[] resultPointArray2 = this.rectangleDetector.detect();
        ResultPoint resultPoint2 = resultPointArray2[0];
        ResultPoint resultPoint3 = resultPointArray2[1];
        ResultPoint resultPoint4 = resultPointArray2[2];
        ResultPoint resultPoint5 = resultPointArray2[3];
        ArrayList<Detector$ResultPointsAndTransitions> arrayList = new ArrayList<Detector$ResultPointsAndTransitions>(4);
        arrayList.add(this.transitionsBetween(resultPoint2, resultPoint3));
        arrayList.add(this.transitionsBetween(resultPoint2, resultPoint4));
        arrayList.add(this.transitionsBetween(resultPoint3, resultPoint5));
        arrayList.add(this.transitionsBetween(resultPoint4, resultPoint5));
        Collections.sort(arrayList, new Detector$ResultPointsAndTransitionsComparator(null));
        Detector$ResultPointsAndTransitions detector$ResultPointsAndTransitions = (Detector$ResultPointsAndTransitions)arrayList.get(0);
        Detector$ResultPointsAndTransitions detector$ResultPointsAndTransitions2 = (Detector$ResultPointsAndTransitions)arrayList.get(1);
        HashMap hashMap = new HashMap();
        Detector.increment(hashMap, detector$ResultPointsAndTransitions.getFrom());
        Detector.increment(hashMap, detector$ResultPointsAndTransitions.getTo());
        Detector.increment(hashMap, detector$ResultPointsAndTransitions2.getFrom());
        Detector.increment(hashMap, detector$ResultPointsAndTransitions2.getTo());
        ResultPoint resultPoint6 = null;
        ResultPoint resultPoint7 = null;
        ResultPoint resultPoint8 = null;
        for (Map.Entry resultPointArray3 : hashMap.entrySet()) {
            resultPoint = (ResultPoint)resultPointArray3.getKey();
            object2 = (Integer)resultPointArray3.getValue();
            if ((Integer)object2 == 2) {
                resultPoint7 = resultPoint;
                continue;
            }
            if (resultPoint6 == null) {
                resultPoint6 = resultPoint;
                continue;
            }
            resultPoint8 = resultPoint;
        }
        if (resultPoint6 == null || resultPoint7 == null || resultPoint8 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        ResultPoint[] resultPointArray = new ResultPoint[]{resultPoint6, resultPoint7, resultPoint8};
        ResultPoint.orderBestPatterns(resultPointArray);
        ResultPoint resultPoint9 = resultPointArray[0];
        resultPoint7 = resultPointArray[1];
        resultPoint = resultPointArray[2];
        object2 = !hashMap.containsKey(resultPoint2) ? resultPoint2 : (!hashMap.containsKey(resultPoint3) ? resultPoint3 : (!hashMap.containsKey(resultPoint4) ? resultPoint4 : resultPoint5));
        int n = this.transitionsBetween(resultPoint, (ResultPoint)object2).getTransitions();
        int n2 = this.transitionsBetween(resultPoint9, (ResultPoint)object2).getTransitions();
        if ((n & 1) == 1) {
            ++n;
        }
        n += 2;
        if ((n2 & 1) == 1) {
            ++n2;
        }
        if (4 * n >= 7 * (n2 += 2) || 4 * n2 >= 7 * n) {
            object = this.correctTopRightRectangular(resultPoint7, resultPoint9, resultPoint, (ResultPoint)object2, n, n2);
            if (object == null) {
                object = object2;
            }
            n = this.transitionsBetween(resultPoint, (ResultPoint)object).getTransitions();
            n2 = this.transitionsBetween(resultPoint9, (ResultPoint)object).getTransitions();
            if ((n & 1) == 1) {
                ++n;
            }
            if ((n2 & 1) == 1) {
                ++n2;
            }
            bitMatrix = Detector.sampleGrid(this.image, resultPoint, resultPoint7, resultPoint9, (ResultPoint)object, n, n2);
        } else {
            int n3 = Math.min(n2, n);
            object = this.correctTopRight(resultPoint7, resultPoint9, resultPoint, (ResultPoint)object2, n3);
            if (object == null) {
                object = object2;
            }
            int n4 = Math.max(this.transitionsBetween(resultPoint, (ResultPoint)object).getTransitions(), this.transitionsBetween(resultPoint9, (ResultPoint)object).getTransitions());
            if ((++n4 & 1) == 1) {
                ++n4;
            }
            bitMatrix = Detector.sampleGrid(this.image, resultPoint, resultPoint7, resultPoint9, (ResultPoint)object, n4, n4);
        }
        return new DetectorResult(bitMatrix, new ResultPoint[]{resultPoint, resultPoint7, resultPoint9, object});
    }

    private ResultPoint correctTopRightRectangular(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) {
        int n3;
        float f2 = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        int n4 = Detector.distance(resultPoint3, resultPoint4);
        float f3 = (resultPoint4.getX() - resultPoint3.getX()) / (float)n4;
        float f4 = (resultPoint4.getY() - resultPoint3.getY()) / (float)n4;
        ResultPoint resultPoint5 = new ResultPoint(resultPoint4.getX() + f2 * f3, resultPoint4.getY() + f2 * f4);
        f2 = (float)Detector.distance(resultPoint, resultPoint3) / (float)n2;
        n4 = Detector.distance(resultPoint2, resultPoint4);
        f3 = (resultPoint4.getX() - resultPoint2.getX()) / (float)n4;
        f4 = (resultPoint4.getY() - resultPoint2.getY()) / (float)n4;
        ResultPoint resultPoint6 = new ResultPoint(resultPoint4.getX() + f2 * f3, resultPoint4.getY() + f2 * f4);
        if (!this.isValid(resultPoint5)) {
            if (this.isValid(resultPoint6)) {
                return resultPoint6;
            }
            return null;
        }
        if (!this.isValid(resultPoint6)) {
            return resultPoint5;
        }
        int n5 = Math.abs(n - this.transitionsBetween(resultPoint3, resultPoint5).getTransitions()) + Math.abs(n2 - this.transitionsBetween(resultPoint2, resultPoint5).getTransitions());
        if (n5 <= (n3 = Math.abs(n - this.transitionsBetween(resultPoint3, resultPoint6).getTransitions()) + Math.abs(n2 - this.transitionsBetween(resultPoint2, resultPoint6).getTransitions()))) {
            return resultPoint5;
        }
        return resultPoint6;
    }

    private ResultPoint correctTopRight(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) {
        int n2;
        float f2 = (float)Detector.distance(resultPoint, resultPoint2) / (float)n;
        int n3 = Detector.distance(resultPoint3, resultPoint4);
        float f3 = (resultPoint4.getX() - resultPoint3.getX()) / (float)n3;
        float f4 = (resultPoint4.getY() - resultPoint3.getY()) / (float)n3;
        ResultPoint resultPoint5 = new ResultPoint(resultPoint4.getX() + f2 * f3, resultPoint4.getY() + f2 * f4);
        f2 = (float)Detector.distance(resultPoint, resultPoint3) / (float)n;
        n3 = Detector.distance(resultPoint2, resultPoint4);
        f3 = (resultPoint4.getX() - resultPoint2.getX()) / (float)n3;
        f4 = (resultPoint4.getY() - resultPoint2.getY()) / (float)n3;
        ResultPoint resultPoint6 = new ResultPoint(resultPoint4.getX() + f2 * f3, resultPoint4.getY() + f2 * f4);
        if (!this.isValid(resultPoint5)) {
            if (this.isValid(resultPoint6)) {
                return resultPoint6;
            }
            return null;
        }
        if (!this.isValid(resultPoint6)) {
            return resultPoint5;
        }
        int n4 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint5).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint5).getTransitions());
        return n4 <= (n2 = Math.abs(this.transitionsBetween(resultPoint3, resultPoint6).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint6).getTransitions())) ? resultPoint5 : resultPoint6;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.getWidth() && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.getHeight();
    }

    private static int distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2));
    }

    private static void increment(Map map, ResultPoint resultPoint) {
        Integer n = (Integer)map.get(resultPoint);
        map.put(resultPoint, n == null ? 1 : n + 1);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n2, 0.5f, 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, (float)n2 - 0.5f, 0.5f, (float)n2 - 0.5f, resultPoint.getX(), resultPoint.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private Detector$ResultPointsAndTransitions transitionsBetween(ResultPoint resultPoint, ResultPoint resultPoint2) {
        int n;
        boolean bl;
        int n2 = (int)resultPoint.getX();
        int n3 = (int)resultPoint.getY();
        int n4 = (int)resultPoint2.getX();
        int n5 = (int)resultPoint2.getY();
        boolean bl2 = bl = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (bl) {
            n = n2;
            n2 = n3;
            n3 = n;
            n = n4;
            n4 = n5;
            n5 = n;
        }
        n = Math.abs(n4 - n2);
        int n6 = Math.abs(n5 - n3);
        int n7 = -n / 2;
        int n8 = n3 < n5 ? 1 : -1;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = 0;
        boolean bl3 = this.image.get(bl ? n3 : n2, bl ? n2 : n3);
        int n11 = n2;
        int n12 = n3;
        while (n11 != n4) {
            boolean bl4 = this.image.get(bl ? n12 : n11, bl ? n11 : n12);
            if (bl4 != bl3) {
                ++n10;
                bl3 = bl4;
            }
            if ((n7 += n6) > 0) {
                if (n12 == n5) break;
                n12 += n8;
                n7 -= n;
            }
            n11 += n9;
        }
        return new Detector$ResultPointsAndTransitions(resultPoint, resultPoint2, n10, null);
    }
}

