/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder;

import java.util.Formatter;
import oz.util.barcode.pdf417.decoder.BarcodeMetadata;
import oz.util.barcode.pdf417.decoder.BoundingBox;
import oz.util.barcode.pdf417.decoder.Codeword;
import oz.util.barcode.pdf417.decoder.DetectionResultColumn;
import oz.util.barcode.pdf417.decoder.DetectionResultRowIndicatorColumn;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n;
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]);
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n2 = 928;
        do {
            n = n2;
        } while ((n2 = this.adjustRowNumbers()) > 0 && n2 < n);
        return this.detectionResultColumns;
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private int adjustRowNumbers() {
        int n = this.adjustRowNumbersByRow();
        if (n == 0) {
            return 0;
        }
        int n2 = 1;
        while (n2 < this.barcodeColumnCount + 1) {
            Codeword[] codewordArray = this.detectionResultColumns[n2].getCodewords();
            int n3 = 0;
            while (n3 < codewordArray.length) {
                if (codewordArray[n3] != null && !codewordArray[n3].hasValidRowNumber()) {
                    this.adjustRowNumbers(n2, n3, codewordArray);
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private int adjustRowNumbersByRow() {
        this.adjustRowNumbersFromBothRI();
        int n = this.adjustRowNumbersFromLRI();
        return n + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        if (this.detectionResultColumns[0] == null || this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return;
        }
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        Codeword[] codewordArray2 = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        int n = 0;
        while (n < codewordArray.length) {
            if (codewordArray[n] != null && codewordArray2[n] != null && codewordArray[n].getRowNumber() == codewordArray2[n].getRowNumber()) {
                int n2 = 1;
                while (n2 <= this.barcodeColumnCount) {
                    Codeword codeword = this.detectionResultColumns[n2].getCodewords()[n];
                    if (codeword != null) {
                        codeword.setRowNumber(codewordArray[n].getRowNumber());
                        if (!codeword.hasValidRowNumber()) {
                            this.detectionResultColumns[n2].getCodewords()[n] = null;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private int adjustRowNumbersFromRRI() {
        if (this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return 0;
        }
        int n = 0;
        Codeword[] codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        int n2 = 0;
        while (n2 < codewordArray.length) {
            if (codewordArray[n2] != null) {
                int n3 = codewordArray[n2].getRowNumber();
                int n4 = 0;
                int n5 = this.barcodeColumnCount + 1;
                while (n5 > 0 && n4 < 2) {
                    Codeword codeword = this.detectionResultColumns[n5].getCodewords()[n2];
                    if (codeword != null) {
                        n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                        if (!codeword.hasValidRowNumber()) {
                            ++n;
                        }
                    }
                    --n5;
                }
            }
            ++n2;
        }
        return n;
    }

    private int adjustRowNumbersFromLRI() {
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        int n = 0;
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        int n2 = 0;
        while (n2 < codewordArray.length) {
            if (codewordArray[n2] != null) {
                int n3 = codewordArray[n2].getRowNumber();
                int n4 = 0;
                int n5 = 1;
                while (n5 < this.barcodeColumnCount + 1 && n4 < 2) {
                    Codeword codeword = this.detectionResultColumns[n5].getCodewords()[n2];
                    if (codeword != null) {
                        n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                        if (!codeword.hasValidRowNumber()) {
                            ++n;
                        }
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        return n;
    }

    private static int adjustRowNumberIfValid(int n, int n2, Codeword codeword) {
        if (codeword == null) {
            return n2;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n)) {
                codeword.setRowNumber(n);
                n2 = 0;
            } else {
                ++n2;
            }
        }
        return n2;
    }

    private void adjustRowNumbers(int n, int n2, Codeword[] codewordArray) {
        Codeword[] codewordArray2;
        Codeword codeword = codewordArray[n2];
        Codeword[] codewordArray3 = codewordArray2 = this.detectionResultColumns[n - 1].getCodewords();
        if (this.detectionResultColumns[n + 1] != null) {
            codewordArray3 = this.detectionResultColumns[n + 1].getCodewords();
        }
        Codeword[] codewordArray4 = new Codeword[14];
        codewordArray4[2] = codewordArray2[n2];
        codewordArray4[3] = codewordArray3[n2];
        if (n2 > 0) {
            codewordArray4[0] = codewordArray[n2 - 1];
            codewordArray4[4] = codewordArray2[n2 - 1];
            codewordArray4[5] = codewordArray3[n2 - 1];
        }
        if (n2 > 1) {
            codewordArray4[8] = codewordArray[n2 - 2];
            codewordArray4[10] = codewordArray2[n2 - 2];
            codewordArray4[11] = codewordArray3[n2 - 2];
        }
        if (n2 < codewordArray.length - 1) {
            codewordArray4[1] = codewordArray[n2 + 1];
            codewordArray4[6] = codewordArray2[n2 + 1];
            codewordArray4[7] = codewordArray3[n2 + 1];
        }
        if (n2 < codewordArray.length - 2) {
            codewordArray4[9] = codewordArray[n2 + 2];
            codewordArray4[12] = codewordArray2[n2 + 2];
            codewordArray4[13] = codewordArray3[n2 + 2];
        }
        Codeword[] codewordArray5 = codewordArray4;
        int n3 = codewordArray4.length;
        int n4 = 0;
        while (n4 < n3) {
            Codeword codeword2 = codewordArray5[n4];
            if (DetectionResult.adjustRowNumber(codeword, codeword2)) {
                return;
            }
            ++n4;
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    void setDetectionResultColumn(int n, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n] = detectionResultColumn;
    }

    DetectionResultColumn getDetectionResultColumn(int n) {
        return this.detectionResultColumns[n];
    }

    public String toString() {
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            detectionResultColumn = this.detectionResultColumns[this.barcodeColumnCount + 1];
        }
        Formatter formatter = new Formatter();
        int n = 0;
        while (n < detectionResultColumn.getCodewords().length) {
            formatter.format("CW %3d:", n);
            int n2 = 0;
            while (n2 < this.barcodeColumnCount + 2) {
                if (this.detectionResultColumns[n2] == null) {
                    formatter.format("    |   ", new Object[0]);
                } else {
                    Codeword codeword = this.detectionResultColumns[n2].getCodewords()[n];
                    if (codeword == null) {
                        formatter.format("    |   ", new Object[0]);
                    } else {
                        formatter.format(" %3d|%3d", codeword.getRowNumber(), codeword.getValue());
                    }
                }
                ++n2;
            }
            formatter.format("%n", new Object[0]);
            ++n;
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }
}

