/*
 * Decompiled with CFR 0.152.
 */
package oz.util.pdf;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oz.util.pdf.OZPDFRenderer_Platform;

public class OZPDFRenderer {
    private static final float RENDER_MAX_SCALE = 2.5f;
    private int mLoadedPageIndex = -1;
    private Object mLock = new Object();
    private Bitmap mCacheBitmap;
    private Paint mPaint = new Paint();
    private OZPDFRenderer_Platform mPlatform;
    private float _posx;
    private float _posy;
    private float _width;
    private float _height;

    public OZPDFRenderer() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setDither(true);
    }

    private File createTempFile() {
        File file = null;
        try {
            file = File.createTempFile(String.format("OZTEMP_%d", System.currentTimeMillis()), ".pdf");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    public boolean openPDF(byte[] byArray) {
        boolean bl = false;
        if (byArray != null) {
            File file = null;
            try {
                file = this.createTempFile();
                file.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray);
                ((OutputStream)fileOutputStream).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (file != null) {
                bl = this.openPDF(file);
                file.delete();
            }
        }
        return bl;
    }

    public boolean openPDF(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            bl = this.openPDF(new File(string));
        }
        return bl;
    }

    public boolean openPDF(File file) {
        boolean bl = false;
        if (file.exists() && file.isFile()) {
            if (this.isOpen()) {
                this.close();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mPlatform == null) {
                    this.mPlatform = new OZPDFRenderer_Platform();
                }
                this.mPlatform.Open(file);
            } else {
                Log.e((String)"OZViewer", (String)"[UserComponent_PDF] can't create. support Android 5.0 or above. check your Android version.");
            }
            if (this.getPageCount() > 0) {
                bl = true;
            } else if (this.isOpen()) {
                this.close();
            }
        }
        return bl;
    }

    public int getPageCount() {
        int n = 0;
        if (this.isOpen()) {
            n = this.mPlatform.getPageCount();
        }
        return n;
    }

    public boolean isOpen() {
        if (this.mPlatform != null) {
            return this.mPlatform.isOpen();
        }
        return false;
    }

    public boolean isOpenPage() {
        if (this.mPlatform != null) {
            return this.mPlatform.isOpenPage();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isOpen()) {
            this.closePage();
            Object object = this.mLock;
            synchronized (object) {
                this.mPlatform.Close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePage() {
        if (this.isOpen() && this.mPlatform.isOpenPage()) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCacheBitmap = null;
                this.mPlatform.ClosePage();
                this.mLoadedPageIndex = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPage(int n) {
        if (this.isOpen()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mLoadedPageIndex != n) {
                    this.closePage();
                    if (n < this.getPageCount()) {
                        this.mPlatform.OpenPage(n);
                        this.mLoadedPageIndex = n;
                    }
                }
            }
            return this.mPlatform.isOpenPage();
        }
        return false;
    }

    public int getPageWidth() {
        int n = 0;
        if (this.isOpen() && this.mPlatform.isOpenPage()) {
            n = this.mPlatform.getPageWidth();
        }
        return n;
    }

    public int getPageHeight() {
        int n = 0;
        if (this.isOpen() && this.mPlatform.isOpenPage()) {
            n = this.mPlatform.getPageHeight();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPage(Canvas canvas, int n, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.loadPage(n)) {
                this.drawLoadedPage(canvas, f2, f3, f4, f5, f6, f7, f8, f9, f10);
            }
        }
    }

    public float getPosX() {
        return this._posx;
    }

    public float getPosY() {
        return this._posy;
    }

    public float getWidth() {
        return this._width;
    }

    public float getHeight() {
        return this._height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLoadedPage(Canvas canvas, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (this.isOpenPage()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isOpenPage()) {
                    if (f4 == 0.0f) {
                        f4 = this.getPageWidth();
                    }
                    if (f5 == 0.0f) {
                        f5 = this.getPageHeight();
                    }
                    RectF rectF = new RectF(f2, f3, f2 + f4, f3 + f5);
                    Rect rect = new Rect((int)f7, (int)f8, (int)((float)this.getPageWidth() - f9), (int)((float)this.getPageHeight() - f10));
                    if (!rectF.isEmpty() && !rect.isEmpty()) {
                        float f11;
                        float f12;
                        float f13 = 1.0f;
                        float f14 = 1.0f;
                        float f15 = 0.0f;
                        float f16 = 0.0f;
                        int n = (int)(rectF.left * f13 + f15);
                        int n2 = (int)(rectF.top * f14 + f16);
                        if (rectF.width() / (float)rect.width() < rectF.height() / (float)rect.height()) {
                            f12 = f13 * rectF.width() / (float)rect.width();
                            f11 = f14 * rectF.width() / (float)rect.width();
                            n2 = (int)((float)n2 + (rectF.height() * f14 - (float)rect.height() * f11) / 2.0f);
                        } else {
                            f11 = f14 * rectF.height() / (float)rect.height();
                            f12 = f13 * rectF.height() / (float)rect.height();
                            n = (int)((float)n + (rectF.width() * f13 - (float)rect.width() * f12) / 2.0f);
                        }
                        int n3 = (int)((float)rect.width() * (f12 *= f6));
                        int n4 = (int)((float)rect.height() * (f11 *= f6));
                        this._width = n3;
                        this._height = n4;
                        if (n3 > 0 && n4 > 0) {
                            n = (int)((float)n * f6);
                            n2 = (int)((float)n2 * f6);
                            this._posx = n;
                            this._posy = n2;
                            if (canvas != null) {
                                float f17 = f12;
                                float f18 = f11;
                                float f19 = Math.max(f17, f18);
                                if (f19 > 2.5f) {
                                    if (f17 == f14) {
                                        f17 = 2.5f;
                                        f18 = 2.5f;
                                    } else {
                                        float f20 = 2.5f / f19;
                                        f17 *= f20;
                                        f18 *= f20;
                                    }
                                }
                                int n5 = (int)((float)this.getPageWidth() * f17);
                                int n6 = (int)((float)this.getPageHeight() * f18);
                                if (this.mCacheBitmap == null || this.mCacheBitmap.getWidth() != n5 || this.mCacheBitmap.getHeight() != n6) {
                                    this.mCacheBitmap = Bitmap.createBitmap((int)n5, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                    Canvas canvas2 = new Canvas(this.mCacheBitmap);
                                    canvas2.drawColor(-1);
                                    this.mPlatform.pageRender(this.mCacheBitmap, null, null);
                                }
                                rect.set((int)((float)rect.left * f17), (int)((float)rect.top * f18), (int)((float)rect.right * f17), (int)((float)rect.bottom * f18));
                                rectF.set((float)n, (float)n2, (float)(n + n3), (float)(n2 + n4));
                                canvas.drawBitmap(this.mCacheBitmap, rect, rectF, this.mPaint);
                            }
                        }
                    }
                }
            }
        }
    }
}

