/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.Image;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.util.Log;
import java.nio.ByteBuffer;

public class CameraUtil {
    private static final String[] CAMERA_PERMISSIONS = new String[]{"android.permission.CAMERA"};
    private static final String TAG = "CameraView";

    public static void i(String string) {
        Log.w((String)TAG, (String)string);
    }

    public static void w(String string) {
        Log.w((String)TAG, (String)string);
    }

    public static void d(String string) {
        Log.d((String)TAG, (String)string);
    }

    public static void e(String string) {
        Log.d((String)TAG, (String)string);
    }

    public static boolean checkCameraHardware(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static boolean hasAllPermissionsGranted(Context context) {
        if (Build.VERSION.SDK_INT > 22) {
            for (String string : CAMERA_PERMISSIONS) {
            }
        }
        return true;
    }

    public static void safeImageClose(Image image) {
        if (image != null) {
            try {
                image.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static byte[] getBytesFromImage(Image image) {
        byte[] byArray = null;
        if (image != null) {
            try {
                ByteBuffer byteBuffer = image.getPlanes()[0].getBuffer();
                byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
            }
        }
        return byArray;
    }

    public static Bitmap getCropAndScaledBitmapFromBytes(byte[] byArray, int n, RectF rectF, RectF rectF2, float f2, float f3, boolean bl) {
        if (byArray != null) {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bitmap != null) {
                float f4;
                boolean bl2;
                boolean bl3 = false;
                RectF rectF3 = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
                Matrix matrix = new Matrix();
                if (n != 0) {
                    matrix.setRotate((float)n, rectF3.width(), rectF3.height());
                    bl3 = true;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = (int)rectF3.width();
                int n5 = (int)rectF3.height();
                float f5 = 1.0f;
                boolean bl4 = bl2 = n == 90 || n == 270;
                if (rectF != null && rectF2 != null) {
                    RectF rectF4 = new RectF(rectF);
                    RectF rectF5 = new RectF(rectF2);
                    rectF5.offset(-rectF4.left, -rectF4.top);
                    if (bl2) {
                        rectF4.set(rectF4.top, rectF4.left, rectF4.bottom, rectF4.right);
                        rectF5.set(rectF5.top, rectF5.left, rectF5.bottom, rectF5.right);
                    }
                    if ((f5 = rectF3.width() / rectF4.width()) != 1.0f) {
                        rectF5.left *= f5;
                        rectF5.top *= f5;
                        rectF5.right *= f5;
                        rectF5.bottom *= f5;
                    }
                    n2 = (int)rectF5.left;
                    n3 = (int)rectF5.top;
                    n4 = Math.round(rectF5.width());
                    n5 = Math.round(rectF5.height());
                    bl3 = true;
                }
                if (bl2) {
                    float f6 = f2;
                    f2 = f3;
                    f3 = f6;
                }
                float f7 = f2 > 0.0f && (float)n4 > f2 ? f2 / (float)n4 : 1.0f;
                float f8 = f4 = f3 > 0.0f && (float)n5 > f3 ? f3 / (float)n5 : 1.0f;
                if (f7 != 1.0f || f4 != 1.0f) {
                    matrix.postScale(f7, f4);
                    bl3 = true;
                }
                if (bl3) {
                    try {
                        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n2, (int)n3, (int)n4, (int)n5, (Matrix)matrix, (boolean)true);
                        if (bl) {
                            Matrix matrix2 = new Matrix();
                            matrix2.setScale(-1.0f, 1.0f);
                            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix2, (boolean)false);
                        }
                        bitmap.recycle();
                        bitmap = bitmap2;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return bitmap;
        }
        return null;
    }

    public static ByteBuffer imageToByteBuffer(Image image) {
        Rect rect = image.getCropRect();
        int n = rect.width();
        int n2 = rect.height();
        Image.Plane[] planeArray = image.getPlanes();
        byte[] byArray = new byte[planeArray[0].getRowStride()];
        int n3 = n * n2 * ImageFormat.getBitsPerPixel((int)35) / 8;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        int n4 = 0;
        int n5 = 0;
        for (int j = 0; j < 3; ++j) {
            if (j == 0) {
                n4 = 0;
                n5 = 1;
            } else if (j == 1) {
                n4 = n * n2 + 1;
                n5 = 2;
            } else if (j == 2) {
                n4 = n * n2;
                n5 = 2;
            }
            ByteBuffer byteBuffer2 = planeArray[j].getBuffer();
            int n6 = planeArray[j].getRowStride();
            int n7 = planeArray[j].getPixelStride();
            int n8 = j == 0 ? 0 : 1;
            int n9 = n >> n8;
            int n10 = n2 >> n8;
            byteBuffer2.position(n6 * (rect.top >> n8) + n7 * (rect.left >> n8));
            for (int k = 0; k < n10; ++k) {
                int n11;
                if (n7 == 1 && n5 == 1) {
                    n11 = n9;
                    byteBuffer2.get(byteBuffer.array(), n4, n11);
                    n4 += n11;
                } else {
                    n11 = (n9 - 1) * n7 + 1;
                    byteBuffer2.get(byArray, 0, n11);
                    for (int i2 = 0; i2 < n9; ++i2) {
                        byteBuffer.array()[n4] = byArray[i2 * n7];
                        n4 += n5;
                    }
                }
                if (k >= n10 - 1) continue;
                byteBuffer2.position(byteBuffer2.position() + n6 - n11);
            }
        }
        return byteBuffer;
    }

    public static Bitmap YUVToBitmapFromImage(Context context, Image image, int n) {
        return CameraUtil.YUVToBitmapFromImage(context, image, n, Bitmap.Config.ARGB_8888);
    }

    public static Bitmap YUVToBitmapFromImage(Context context, Image image, int n, Bitmap.Config config) {
        if (context != null && image != null) {
            ByteBuffer byteBuffer = null;
            try {
                byteBuffer = CameraUtil.imageToByteBuffer(image);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (byteBuffer != null) {
                Bitmap bitmap = null;
                try {
                    bitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bitmap != null) {
                    Matrix matrix;
                    RenderScript renderScript = RenderScript.create((Context)context);
                    Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap);
                    Allocation allocation2 = Allocation.createSized((RenderScript)renderScript, (Element)Element.U8((RenderScript)renderScript), (int)byteBuffer.array().length);
                    allocation2.copyFrom(byteBuffer.array());
                    ScriptIntrinsicYuvToRGB scriptIntrinsicYuvToRGB = ScriptIntrinsicYuvToRGB.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
                    scriptIntrinsicYuvToRGB.setInput(allocation2);
                    scriptIntrinsicYuvToRGB.forEach(allocation);
                    allocation.copyTo(bitmap);
                    allocation2.destroy();
                    allocation.destroy();
                    renderScript.destroy();
                    if (n != 0) {
                        matrix = new Matrix();
                        matrix.setRotate((float)n, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
                        try {
                            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                            bitmap.recycle();
                            bitmap = bitmap2;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (config != Bitmap.Config.ARGB_8888) {
                        matrix = bitmap.copy(config, true);
                        bitmap.recycle();
                        bitmap = matrix;
                    }
                }
                return bitmap;
            }
        }
        return null;
    }
}

