/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.history;

import java.util.ArrayList;
import oz.viewer.ui.history.HistoryNavigationCompData;
import oz.viewer.ui.history.HistoryNavigationManager;
import oz.viewer.ui.history.HistoryNavigationRevisionData;

public class HistoryNavigationData {
    private HistoryNavigationRevisionData mRevision;
    private ArrayList mData;

    public HistoryNavigationData(HistoryNavigationRevisionData historyNavigationRevisionData) {
        this.mRevision = historyNavigationRevisionData;
        this.mData = new ArrayList();
    }

    public void clearItem() {
        this.mData.clear();
    }

    public int getItemSize() {
        return this.mData.size();
    }

    public void addItem(HistoryNavigationCompData historyNavigationCompData) {
        this.mData.add(historyNavigationCompData);
    }

    public HistoryNavigationCompData getItem(int n) {
        return (HistoryNavigationCompData)this.mData.get(n);
    }

    public ArrayList getItems() {
        return this.mData;
    }

    public HistoryNavigationCompData findItem(int n) {
        ArrayList arrayList = HistoryNavigationManager.findItemsByUniqueZOrder(this.mData, n);
        HistoryNavigationCompData historyNavigationCompData = null;
        if (arrayList.size() > 0) {
            historyNavigationCompData = (HistoryNavigationCompData)arrayList.get(0);
        }
        return historyNavigationCompData;
    }

    public int getRevisionVersion() {
        return this.mRevision.version;
    }

    public String getRevisionUserID() {
        return this.mRevision.userID;
    }

    public String getRevisionUserName() {
        return this.mRevision.userName;
    }

    public String getRevisionAddress() {
        return this.mRevision.address;
    }

    public long getRevisionTime() {
        return this.mRevision.time;
    }

    public long getRevisionSaveTime() {
        return this.mRevision.saveTime;
    }

    public HistoryNavigationRevisionData getRevision() {
        return this.mRevision;
    }
}

