package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * {@link AcmsClient#contentVersion} の戻り値です。
 * @author Taejin Hong
 * @version 1.0.0
 */

public class ChatPushDataJSON  extends AcmsCommonJSON {
    private static final String PushMessage = "pushMessage";
    private static final String PushSendLoginId = "pushSendLoginId";
    private static final String PushSendDate = "pushSendDate";
    private static final String RoomId = "roomId";
    private static final String RoomName = "roomName";
    private static final String ChatMessage = "chatMessage";

    //public JSONObject pushMessage;
    public ArrayList<PushMessageDto> pushMessageList;
    public ChatPushDataJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {
        // 絞り検索のデータを取得
        if(json.has(PushMessage)) {
            JSONArray pushMessagetJsonArray = json.getJSONArray(PushMessage);
            if (pushMessagetJsonArray != null) {
                pushMessageList = new ArrayList<PushMessageDto>();
                for (int k = 0; k < pushMessagetJsonArray.length(); k++) {
                    if (pushMessagetJsonArray.getJSONObject(k).length() == 0) {
                        break;
                    }
                    PushMessageDto pushMessageDto = new PushMessageDto();
                    String tempDate = DateTimeUtil.toString(DateTimeUtil.toDate(pushMessagetJsonArray.getJSONObject(k).getString(PushSendDate), DateTimeFormat.yyyyMMddHHmmss_hyphen), DateTimeFormat.yyyyMMddHHmmssSSS_none);
                    pushMessageDto.pushMessageId = Long.valueOf(tempDate);
                    pushMessageDto.operationId = Long.valueOf(tempDate+1);
                    pushMessageDto.pushSendLoginId = pushMessagetJsonArray.getJSONObject(k).getString(PushSendLoginId);
                    pushMessageDto.pushSendDate = DateTimeUtil.toDate(pushMessagetJsonArray.getJSONObject(k).getString(PushSendDate), DateTimeFormat.yyyyMMddHHmmss_hyphen);
                    pushMessageDto.roomId = pushMessagetJsonArray.getJSONObject(k).getLong(RoomId);
                    pushMessageDto.roomName = pushMessagetJsonArray.getJSONObject(k).getString(RoomName);
                    pushMessageDto.pushMessage = pushMessagetJsonArray.getJSONObject(k).getString(ChatMessage);
                    pushMessageDto.readingFlg = false;
                    pushMessageList.add(pushMessageDto);
                }
            }
        }
    }
}

