package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.dto.FixPushMessageDto;

/**
 * Created by kim jinsung on 2018/09/15.
 */

public class FixPushMessageJSON  extends AcmsCommonJSON {
    public static final String PushMessage = "pushMessage";
    public static final String Name = "name";
    public static final String Value = "value";
    public List<FixPushMessageDto> fixPushMessageDtoList;

    public FixPushMessageJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) {
        fixPushMessageDtoList = new ArrayList<FixPushMessageDto>();
        if (json.has(PushMessage)) {
            JSONArray fixPushMessageList = json.getJSONArray(PushMessage);
            for (int i = 0; i < fixPushMessageList.length(); i++) {
                JSONObject fixPushMessageObject = fixPushMessageList.getJSONObject(i);
                FixPushMessageDto dto = new FixPushMessageDto();
                if (!fixPushMessageObject.has(Name)) {
                    continue;
                }
                dto.name = fixPushMessageObject.getString(Name);
                dto.value = fixPushMessageObject.getString(Value);
                fixPushMessageDtoList.add(dto);
            }
        }
    }
}
