package jp.agentec.abook.abv.bl.acms.client.json.content;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;

public class PhaseInfoJSON extends AbstractJSON {

    public static final String PHASE_GROUP_LIST = "phaseGroupList";

    public static final String PHASE_GROUP_ID = "phaseGroupId";

    public PhaseInfoJSON(String json) {
        super(json);
    }

    /**
     * get phase Group ID List by phaseNo
     * @param phaseNo
     * @return
     */
    public List<Integer> getPhaseGroupIds(String phaseNo) {
        List<Integer> phaseGroupIds = new ArrayList<Integer>();
        try {
            JSONArray timeLineListJSONArray =  root.getJSONArray(ABookKeys.TIME_LINE_LIST);
            for (int listCount = 0; listCount < timeLineListJSONArray.length(); listCount++) {
                if (timeLineListJSONArray.getJSONObject(listCount).length() == 0) {
                    break;
                }
                JSONObject timeLineJSONObject = timeLineListJSONArray.getJSONObject(listCount);
                JSONArray phaseListJSONArray =  timeLineJSONObject.getJSONArray(ABookKeys.PHASE_LIST);
                for (int phaseListCount = 0; phaseListCount < phaseListJSONArray.length(); phaseListCount++) {
                    if (phaseListJSONArray.getJSONObject(phaseListCount).length() == 0) {
                        break;
                    }
                    JSONObject phaseListJSONObject = phaseListJSONArray.getJSONObject(phaseListCount);
                    if (phaseListJSONObject.has(ABookKeys.PHASE_NO)) {
                        if (phaseListJSONObject.getString(ABookKeys.PHASE_NO).contentEquals(phaseNo)) {
                            if (phaseListJSONObject.has(PHASE_GROUP_LIST)) {
                                JSONArray phaseGroupListJSONArray =  phaseListJSONObject.getJSONArray(PHASE_GROUP_LIST);
                                for (int phaseGroupListCount = 0; phaseGroupListCount < phaseGroupListJSONArray.length(); phaseGroupListCount++) {
                                    if (phaseGroupListJSONArray.getJSONObject(phaseGroupListCount).length() == 0) {
                                        break;
                                    }
                                    JSONObject phaseGroupListJSONObject = phaseGroupListJSONArray.getJSONObject(phaseGroupListCount);
                                    if (phaseGroupListJSONObject.has(PHASE_GROUP_ID)) {
                                        phaseGroupIds.add(phaseGroupListJSONObject.getInt(PHASE_GROUP_ID));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {}
        return phaseGroupIds;
    }
}
