package jp.agentec.abook.abv.bl.acms.type;

/**
 * ダウンロードするZIPファイルの種類を示します。
 * @author Taejin Hong
 * @version 1.0.0 
 */
public enum ContentZipType {
	/**
	 * 新着コンテンツ情報(contentInfo.zip)
	 * @since 1.0.0
	 */
	ContentInfo(1),
	/**
	 * コンテンツ詳細情報(contentDetail.zip)
	 * @since 1.0.0  
	 */
	ContentDetail(3),
	/**
	 * コンテンツ(contentDownload.zip)
	 * @since 1.0.0  
	 */
	ContentDownload(2);
	
	private final int index;
	
	ContentZipType(int index) {
		this.index = index;
	}
	
	/**
	 * 値を数字で表示します。
	 * @return 値の数字です。
	 * @since 1.0.0
	 */
	public int type() {
		return index;
	}
}
