package jp.agentec.abook.abv.bl.acms.type;

/**
 * サービスオプションの識別子です。
 * @author Taejin Hong
 * @version 1.0.0
 */
public enum ServiceOptionId {
	/**
	 * トランスコーダ使用
	 * @since 1.0.0
	 */
	Transcoder(11),
	/**
	 * 公開終了時のDL済コンテンツ強制削除
	 * @since 1.0.0
	 */
	UndeliverableDelete(13),
	/**
	 * 権限喪失,非公開,削除時のDL済コンテンツ強制削除
	 * @since 1.0.0
	 */
	NoauthDelete(14),
	/**
	 * Office使用可
	 * @since 1.2.0
	 */
	Office2pdf(17),
	/**
	 * 初回ログイン時パスワード強制変更
	 * @since 1.0.0
	 */
	ForcePwChangeOnLogin(21),
	/**
	 * 定期ログイン時パスワード強制変更
	 * @since 1.0.0
	 */
	ForcePwChangePeriodically(22),
	/**
	 * 強制ログイン促し
	 * @since 1.0.0
	 */
	ForceLoginPeriodically(23),
	/**
	 * UseridUdidOverwrite
	 * @since 1.0.0
	 */
	UseridUdidOverwrite(26),
	/**
	 * PDF 배경색설정
	 * @since 1.0.0
	 */
	Pdf_link_disp(32),
	/**
	 * マーキング機能使用
	 * @since 1.0.0
	 */
	Marking(33),
	/**
	 * 連動機能使用
	 * @since 4.0.0
	 */
	ViewerSync(34),
	/**
	 * コンテンツ警告
	 * @since 4.0.0
	 */
	ContentAlert(37),
	/**
	 * PDF_Text copy 옵션
	 * @since 1.0.0
	 */
	PdfTextCopy(42),
	/**
	 * 任意のプッシュメッセージ
	 * @since 1.0.0
	 */
	usablePushMessage(49),
	/**
	 * コンテンツコンテナ
	 * @since 1.2.0
	 */
	ContentContainer(54),
	/**
	 * 強制ログアウト
	 * @since 4.0.0
	 */
	ForceOfflineLogout(58),
	/**
	 * 強制ログアウト タイムアウト日数
	 * @since 4.0.0
	 */
	ForceOfflineWait(59),
	/**
	 * 閲覧ログGPS使用可
	 * @since 1.1.0
	 */
	UsableReadinglogGps(71),
	/**
	 * 閲覧ログ詳細ログ使用可
	 * @since 1.1.0
	 */
	UsableReadinglogObject(72),
	/**
	 * iPad
	 * @since 1.0.0
	 */
	iPad(302),
	/**
	 * iPhone
	 * @since 1.0.0
	 */
	iPhone(303),
	/**
	 * Android
	 * @since 1.0.0
	 */
	Android(404);

	private final int serviceOptionId;
	
	ServiceOptionId(int serviceOptionId) {
		this.serviceOptionId = serviceOptionId;
	}
	
	/**
	 * サービスオピョションIDを返します。
	 * @return サービスオピョションIDです。
	 * @since 1.0.0
	 */
	public int id() {
		return serviceOptionId;
	}
}
