package jp.agentec.abook.abv.bl.repo;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.nw.PCNetworkAdapter;
import jp.agentec.abook.abv.bl.data.DBConnector;

import org.junit.BeforeClass;
import org.junit.Test;

public class RepoClientTest {
	RepoClient repoClient = RepoClient.getInstance();
	private String repositoryFqdn = "s.abook.bz";
	private static boolean created = false;

	@BeforeClass
	public static void setUp() throws Exception {
		ABVEnvironment.getInstance().isReader = true;
		if (!created) {
			DBConnector conn = DBConnector.getInstance();
			SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
			conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
			((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
			created = true;
		}
		ABVEnvironment.getInstance().networkAdapter = new PCNetworkAdapter();
	}

	@Test
	public void getServerDate() throws Exception {
		System.out.println(repoClient.getServerDate(repositoryFqdn));
	}
	
	@Test
	public void transferMaster() throws Exception {
		System.out.println(repoClient.transferMaster(repositoryFqdn));
	}
	
	@Test
	public void getCmsUrl() throws Exception {
		System.out.println(repoClient.getCmsUrl(repositoryFqdn, 1, "android").url);
	}
	
	

}
