package jp.agentec.abook.abv.bl.common.db.impl;

import jp.agentec.abook.abv.bl.common.db.Cursor;
import jp.agentec.abook.abv.bl.common.exception.ABVRuntimeException;
import jp.agentec.abook.abv.bl.common.log.Logger;

public class StandardCursor implements Cursor {
	private android.database.Cursor cursor;

	public StandardCursor(android.database.Cursor cursor) {
		this.cursor = cursor;
	}

	@Override
	public void close() {
		try {
			cursor.close();
		} catch (Exception e) { // finallyで呼ばれるため例外はスローしないようにする
			Logger.e("StandardCursor", "close error.", e);
		}
	}

	@Override
	public byte[] getBlob(int columnIndex) {
		return cursor.getBlob(columnIndex);
	}

	@Override
	public int getColumnCount() {
		return cursor.getColumnCount();
	}

	@Override
	public int getColumnIndex(String columnName) {
		return cursor.getColumnIndex(columnName);
	}

	@Override
	public int getColumnIndexOrThrow(String columnName) {
		return cursor.getColumnIndexOrThrow(columnName);
	}

	@Override
	public String getColumnName(int columnIndex) {
		return cursor.getColumnName(columnIndex);
	}

	@Override
	public String[] getColumnNames() {
		return cursor.getColumnNames();
	}

	@Override
	public int getCount() {
		return cursor.getCount();
	}

	@Override
	public double getDouble(int columnIndex) {
		return cursor.getDouble(columnIndex);
	}

	@Override
	public float getFloat(int columnIndex) {
		return cursor.getFloat(columnIndex);
	}

	@Override
	public int getInt(int columnIndex) {
		return cursor.getInt(columnIndex);
	}

	@Override
	public long getLong(int columnIndex) {
		return cursor.getLong(columnIndex);
	}

	@Override
	public short getShort(int columnIndex) {
		return cursor.getShort(columnIndex);
	}

	@Override
	public String getString(int columnIndex) {
		return cursor.getString(columnIndex);
	}

	@Override
	public int getType(int columnIndex) {
		throw new ABVRuntimeException("getType not supported in this sdk version"); // APIバージョンが１１より低いとgetTypeがない
//		return cursor.getType(columnIndex);
	}

	@Override
	public boolean isAfterLast() {
		return cursor.isAfterLast();
	}

	@Override
	public boolean isBeforeFirst() {
		return cursor.isBeforeFirst();
	}

	@Override
	public boolean isClosed() {
		return cursor.isClosed();
	}

	@Override
	public boolean isFirst() {
		return cursor.isFirst();
	}

	@Override
	public boolean isLast() {
		return cursor.isLast();
	}

	@Override
	public boolean isNull(int columnIndex) {
		return cursor.isNull(columnIndex);
	}

	@Override
	public boolean move(int offset) {
		return cursor.move(offset);
	}

	@Override
	public boolean moveToFirst() {
		return cursor.moveToFirst();
	}

	@Override
	public boolean moveToLast() {
		return cursor.moveToLast();
	}

	@Override
	public boolean moveToNext() {
		return cursor.moveToNext();
	}
	
	

}
