package jp.agentec.abook.abv.cl.helper;

import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.DefPrefKey;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.UserPrefKey;
import jp.agentec.abook.abv.ui.common.vo.Size;
import jp.agentec.adf.util.NumericUtil;
import android.content.Context;

public class PreferenceHelper {
	private static final String TAG = "PreferenceHelper";
	private static PreferenceHelper instance; 

	private Context mContext;

	public static PreferenceHelper getInstance() {
		if (instance == null) {
			synchronized (PreferenceHelper.class) {
				if (instance == null) {
					instance = new PreferenceHelper();
				}
			}
		}

		return instance;
	}

	private PreferenceHelper() {
	}

	public void init(Context context) {
		mContext = context;
	}
	
	public boolean hasContext() {
		return mContext != null;
	}

	public Size getPdfImageSize(Size defSize) {
		if (PreferenceUtil.userPrefContains(mContext, UserPrefKey.PDF_IMAGE_SIZE)) {
			String val = PreferenceUtil.getUserPref(mContext, UserPrefKey.PDF_IMAGE_SIZE, "");
			if (val.contains("x")) {
				return new Size(NumericUtil.parseInt(val.substring(0, val.indexOf("x"))), NumericUtil.parseInt(val.substring(val.indexOf("x") + 1)));
			}
		}
		return defSize;
	}

	public void setDisplaySizeForSignage(Size size) {
        PreferenceUtil.put(mContext, UserPrefKey.SIGNAGE_HEIGHT, size.height);
        PreferenceUtil.put(mContext, UserPrefKey.SIGNAGE_WIDTH, size.width);
    }

    public Size getDisplaySizeForSignage(Size defaultSize) {
        int height = PreferenceUtil.get(mContext, UserPrefKey.SIGNAGE_HEIGHT, defaultSize.height);
        int width = PreferenceUtil.get(mContext, UserPrefKey.SIGNAGE_WIDTH, defaultSize.width);

		if (defaultSize.width > defaultSize.height && width > height || defaultSize.width < defaultSize.height && width < height) {
			return new Size(width, height);
		} else {
			return new Size(height, width);
		}
    }

    /**
     * アプリがバージョンアップ中であるかの確認フラグ
     * SmartLinkの場合、自動起動がONになっているとバージョンアップが中断されることがあるため。
     * @return boolean
     */
	public boolean isAppVersionUpProcessing() {
        return PreferenceUtil.get(mContext, DefPrefKey.APP_VERSIONUP_PROCESSING, false);
    }

}
