package jp.agentec.abook.abv.cl.util;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.UUID;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.adf.util.StringUtil;

public class AlcoholCheckerUtil {
    public static final String TAG = "AlcoholCheckerUtil";

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// BLEService
    public static final String ACTION_GATT_CONNECTED    = "com.taiyoyuden.tysab_terminal.ACTION_GATT_CONNECTED";
    /**
     * @brief Intent broadcast when remote GATT server is no longer connected
     * \hideinitializer
     */
    public static final String ACTION_GATT_DISCONNECTED = "com.taiyoyuden.tysab_terminal.ACTION_GATT_DISCONNECTED";
    /**
     * @brief Intent broadcast when remote device service discovery is finished
     * \hideinitializer
     */
    public static final String ACTION_GATT_SERVICES     = "com.taiyoyuden.tysab_terminal.ACTION_GATT_SERVICES";
    /**
     * @brief Intent broadcast on data received from remote device
     * \hideinitializer
     */
    public static final String ACTION_DATA_RECEIVED     = "com.taiyoyuden.tysab_terminal.ACTION_DATA_RECEIVED";

    // @PERIPHERAL_NAME
    private static final String PERIPHERAL_NAME = "FALC-31";

    public static final UUID CCCD                  = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");

    public static final UUID TY_SERVICE_UUID        = UUID.fromString("442F1570-8A00-9A28-CBE1-E1D4212D53EB");    // Taiyo Yuden Service UUID
    public static final UUID NOTIFICATION_CHARACTERISTIC_UUID = UUID.fromString("442F1571-8A00-9A28-CBE1-E1D4212D53EB");    // Taiyo Yuden Read Notification Characteristic
    public static final UUID WRITE_NO_RESPONSE_CHARACTERISTIC_UUID = UUID.fromString("442F1572-8A00-9A28-CBE1-E1D4212D53EB"); // Taiyo Yuden Write No Response Characteristic



    public static final UUID INDICATION_CHARACTERISTIC_UUID = UUID.fromString("442F1573-8A00-9A28-CBE1-E1D4212D53EB"); // Taiyo Yuden Read Indication Characteristic
    public static final UUID WRITE_CHARACTERISTIC_UUID = UUID.fromString("442F1574-8A00-9A28-CBE1-E1D4212D53EB");    // Taiyo Yuden Write Characteristic
    public static final UUID BATTERY_SERVICE_UUID = UUID.fromString("0000180f-0000-1000-8000-00805f9b34fb");
    public static final UUID BATTERY_LEVEL_UUID = UUID.fromString("00002a19-0000-1000-8000-00805f9b34fb");

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// BLEService
    // @
    private boolean mIsBluetoothEnable		= false;
    public static final String ACTION_PHY_READ = "com.taiyoyuden.tysab_terminal.ACTION_PHY_READ";
    public static final String ACTION_DESCRIPTOR_WROTE = "com.taiyoyuden.tysab_terminal.ACTION_DESCRIPTOR_WROTE";

    // @BLE Tx State
    public int gi_status;                                // BLE Tx Status
    public boolean gf_result_flg;                        // Conc Data Get    // RD RPを切り替えるフラグ
    public static final int F_BLE_COM_INIT = 0;    // BLE Init
    public static final int F_BLE_COM_RP_START = 1;     // RP Command Send
    public static final int F_BLE_COM_RP_WAIT = 2;      // RP Command Send Wait
    public static final int F_BLE_COM_RD_START = 3;     // RD Command Send
    public static final int F_BLE_COM_RD_WAIT = 4;      // RD Command Send Wait
    public static final int F_BLE_COM_RECONNECT1 = 5;   // ReConecting(NOTIFICATION Disable)
    public static final int F_BLE_COM_RECONNECT2 = 6;   // ReConecting(Wait)
    public static final int F_BLE_COM_RECONNECT3 = 7;   // ReConecting(NOTIFICATION Enable)
    public static final int F_BLE_COM_FC_START = 8;     // FC Command Sned
    public static final int F_BLE_COM_FC_WAIT = 9;      // FC Command Wait
    public static final int F_BLE_COM_FC_START22 = 10;  // RDYに戻す FC Command Send
    public static final int F_BLE_COM_FC_WAIT22 = 11;   // RDYに戻す FC Command Wait

    // @BLE Command
    public static final String F_BLE_COM_RP_COMMAND = "01525000A304";  // 01 52 50 00 A3 04    // RP 送信
    public static final String F_BLE_COM_RD_COMMAND = "015244009704";  // 01 52 44 00 97 04    // RD 送信

    public static final String F_BLE_COM_FC_COMMAND_F11 = "01464301F17C04"; // BLE接続解除  // 01 46 43 01 F1 7C 04
    public static final String F_BLE_COM_FC_COMMAND_F22 = "01464301F27D04"; // 測定中断     // 01 46 43 01 F2 7D 04 // READY に戻す
    public static final String F_BLE_COM_FC_COMMAND_F33 = "01464301F37E04"; // 測定開始     // 01 46 43 01 F3 7E 04

    public static final String F_BLE_COM_RC_COMMAND_D   = "0152430144DB04"; // 切断し接続方法選択状態へ戻る　　01 52 43 01 44 DB 04

    // @BLE Rx
    private final int F_RX_BUFSIZE = 32;
    private byte gb_rxdat[] = new byte[F_RX_BUFSIZE];
    public int gi_rxlength;
    public final int F_RX_COMMAND_POS = 1;        // Command Position

    private final int F_RX_RP_LENGTH = 8;
    private final byte F_RP_COMMAND_MSB = (byte) 0x72;
    private final byte F_RP_COMMAND_LSB = (byte) 0x70;
    private final int F_RX_RP_MODE_POS = 5;        // RP MODE Position

    private final int F_RX_RD_LENGTH = 28;
    private final byte F_RD_COMMAND_MSB = (byte) 0x72;
    private final byte F_RD_COMMAND_LSB = (byte) 0x64;
    private final int F_RX_RD_DATA_POS = 9;        // Conc Data Position

    public int gi_rxretry_cnt;                // BLE Connect Error Retry Counter		// @@@

    private enum FORMAT {Ascii, Hex};

    private enum EOL_TYPE {None, CR, LF, CRLF};

    private static FORMAT input_format = FORMAT.Ascii;
    private static EOL_TYPE eol_type = EOL_TYPE.None;

    public static final UUID RX_CHARACTERISTIC_UUID = UUID.fromString("442F1571-8A00-9A28-CBE1-E1D4212D53EB");    // Taiyo Yuden Rx Characteristic
    public static final UUID TX_CHARACTERISTIC_UUID = UUID.fromString("442F1572-8A00-9A28-CBE1-E1D4212D53EB");    // Taiyo Yuden Tx Characteristic

    private final int MAX_MESSAGE_COUNT = 20;   // Number of messages to show in UI

    public static final String ACTION_TX_FINISHED = "com.taiyoyuden.tyapp_terminal.ACTION_TX_FINISHED";
    public static final String ACTION_TX_ERROR = "com.taiyoyuden.tyapp_terminal.ACTION_TX_ERROR";

    public static BluetoothGattCharacteristic RxChar;        // @@@
    public static BluetoothGattCharacteristic TxChar;        // @@@

    private BluetoothGattService TaiyoYudenService;
    private BluetoothGattService BatteryService;
    private BluetoothGattCharacteristic NotificationChar;
    private BluetoothGattCharacteristic WriteChar;
    public BluetoothGattCharacteristic IndicationChar;
    public BluetoothGattCharacteristic batteryLevelChar;
    private int connectionPHY = 0;

    /////////////////////////////////////////////////////////////////////////////////////////////////////////
    private Context context;
    public BleManagerUtil bleManagerUtil;
    private AlcoholCheckerUtilListener listener;
    public static boolean isConnected = false;

    // アルコール濃度
    private String strAlcoholValue = "";

    // ステータス
    public static final int fugo_init = 0;
    public static final int fugo_wait_connect = 1;
    public static final int fugo_conntected = 2;
    public static final int fugo_wait_go = 3;
    public static final int fugo_fu_error = 4;
    public static final int fugo_restart = 5;
    public static final int fugo_finish = 6;

    private boolean isFirst = true;

    // mutex
    private Object lockObj = new Object();
    private Handler handler = new Handler();
    public BleManagerUtilListener bleManagerUtilListener = new BleManagerUtilListener() {

        @Override
        public void onGetDeviceInfoFailed(int status) {

        }

        @Override
        public void onGetDeviceInfo(String strTemperature) {

        }

        @Override
        public void onConnectionState(int status) {
            Logger.d(TAG,"onConnectionState = %s", status);

        }

        @Override
        public void onDisConnectionState() {
        }

        @Override
        public void onConnectionError(int status) {
            Logger.d(TAG,"onConnectionError = %s", status);
            listener.onConnectionError(status);
        }

        @Override
        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Logger.i(TAG,"onServicesDiscovered = %s", status);
            if (status == BluetoothGatt.GATT_SUCCESS) {
                Logger.i(TAG,"BluetoothGatt.GATT_SUCCESS");

                TaiyoYudenService = gatt.getService(TY_SERVICE_UUID);
                if (TaiyoYudenService == null) {
                    Logger.e(TAG,"Not a TaiyoYuden device");
                } else {
                    // Check TX and RX UUIDs
                    RxChar = TaiyoYudenService.getCharacteristic(RX_CHARACTERISTIC_UUID);
                    TxChar = TaiyoYudenService.getCharacteristic(TX_CHARACTERISTIC_UUID);
                    if (RxChar == null || TxChar == null) {
                        Logger.e(TAG, "No Tx/Rx");
                    } else {
                        gatt.requestConnectionPriority(BluetoothGatt.CONNECTION_PRIORITY_HIGH);

                        BatteryService = gatt.getService(BATTERY_SERVICE_UUID);
                        NotificationChar = TaiyoYudenService.getCharacteristic(NOTIFICATION_CHARACTERISTIC_UUID);
                        IndicationChar = TaiyoYudenService.getCharacteristic(INDICATION_CHARACTERISTIC_UUID);
                        WriteChar = TaiyoYudenService.getCharacteristic(WRITE_NO_RESPONSE_CHARACTERISTIC_UUID);
                        batteryLevelChar = BatteryService.getCharacteristic(BATTERY_LEVEL_UUID);
                        connectionPHY = 0;

                        //gatt.readPhy();

                        gatt.setCharacteristicNotification(NotificationChar,true);
                        BluetoothGattDescriptor notification_descriptor = NotificationChar.getDescriptor(CCCD);
                        notification_descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                        gatt.writeDescriptor(notification_descriptor);
                        //gi_status = F_BLE_COM_INIT;
                        bleManagerUtil.setBluetoothGatt(gatt);

                        gi_rxlength = 0;
                        gf_result_flg = false;
                        gi_rxretry_cnt = 0;

                        gi_status = F_BLE_COM_RP_START;

                        SendMessageFromCentral(gi_status);

                        listener.onServicesDiscovered(status);
                    }
                }
            } else {

            }
        }

        @Override
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            Logger.d(TAG,"onCharacteristicChanged start");
            synchronized (lockObj) {
                byte[] rx = characteristic.getValue();

                String rxStr = "  ";
                if (rx != null && rx.length > 0) {
                    for (byte rx1 : rx) {
                        rxStr += rx1 + " ,";
                    }
                }
                sub_rx_chk(rx);
            }
            Logger.d(TAG,"onCharacteristicChanged end");
        }


        @Override
        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            UUID characteristic_uuid = descriptor.getCharacteristic().getUuid();

            if (gatt.getService(TY_SERVICE_UUID).getCharacteristic(INDICATION_CHARACTERISTIC_UUID) == null) {
                Logger.e(TAG, "Old version");
                // This version doesn't support latest characteristics
                return;
            }

            if (characteristic_uuid.equals(NOTIFICATION_CHARACTERISTIC_UUID)) {
                gatt.setCharacteristicNotification(IndicationChar, true);
                BluetoothGattDescriptor indication_descriptor = IndicationChar.getDescriptor(CCCD);
                indication_descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                gatt.writeDescriptor(indication_descriptor);
            } else if (characteristic_uuid.equals(INDICATION_CHARACTERISTIC_UUID)) {
                gatt.setCharacteristicNotification(batteryLevelChar, true);
                BluetoothGattDescriptor notification_descriptor = batteryLevelChar.getDescriptor(CCCD);
                notification_descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(notification_descriptor);
            } else if (characteristic_uuid.equals(BATTERY_LEVEL_UUID)) {
                Logger.i(TAG, "Wrote descriptor: " + BATTERY_LEVEL_UUID);
            }
        }
    };

    public AlcoholCheckerUtil(Context context, AlcoholCheckerUtilListener listener) {
        this.context = context;
        isConnected = false;
        this.listener = listener;
        isFirst = true;
    }

    public void finish() {
        Logger.d(TAG,"finish");
        isConnected = false;
        disconnect();
    }

    // Bluetoothアダプタの取得処理
    public boolean startGetDeviceInfo() {

        // BLE管理
        bleManagerUtil = new BleManagerUtil(context, bleManagerUtilListener);

        if (!bleManagerUtil.startDeviceInfo()) {
            return false;
        }

        return true;
    }

    public void initAlcoholCheckerSettings(BluetoothGatt gatt) {
        Logger.d(TAG,"initAlcoholCheckerSettings");
        if (gatt != null) {
            TaiyoYudenService = gatt.getService(TY_SERVICE_UUID);
            BatteryService = gatt.getService(BATTERY_SERVICE_UUID);
            NotificationChar = TaiyoYudenService.getCharacteristic(NOTIFICATION_CHARACTERISTIC_UUID);
            IndicationChar = TaiyoYudenService.getCharacteristic(INDICATION_CHARACTERISTIC_UUID);
            WriteChar = TaiyoYudenService.getCharacteristic(WRITE_NO_RESPONSE_CHARACTERISTIC_UUID);
            batteryLevelChar = BatteryService.getCharacteristic(BATTERY_LEVEL_UUID);
            connectionPHY = 0;
            gatt.readPhy();

            gatt.setCharacteristicNotification(NotificationChar,true);
            BluetoothGattDescriptor notification_descriptor = NotificationChar.getDescriptor(CCCD);
            notification_descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            gatt.writeDescriptor(notification_descriptor);
        } else {
            Logger.e(TAG,"initAlcoholCheckerSettings gatt is null");
        }
    }

    public void SendMessageFromCentral(final int giStatus) {
        Logger.d(TAG,"SendMessageFromCentral");

        if (giStatus == F_BLE_COM_RP_START || giStatus == F_BLE_COM_RD_START || giStatus == F_BLE_COM_FC_START || giStatus == F_BLE_COM_FC_START22) {
            Logger.d(TAG, "gi_status = " + giStatus);
        } else {
            Logger.w(TAG, "UNKOWN COMMAND");
        }
        long delay = 1000;
        if (isFirst) {
            delay = 3000;
            Logger.d(TAG,"SendMessage delayTime:" + delay);
            isFirst = false;
        }

        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                synchronized (lockObj) {
                    if (giStatus == F_BLE_COM_RP_START) {
                        Logger.d(TAG, "F_BLE_COM_RP_START");
                        sendMessage(F_BLE_COM_RP_COMMAND);
                    } else if (giStatus == F_BLE_COM_RD_START) {
                        Logger.d(TAG, "F_BLE_COM_RD_START");
                        sendMessage(F_BLE_COM_RD_COMMAND);
                    } else if (giStatus == F_BLE_COM_FC_START) {
                        Logger.d(TAG, "F_BLE_COM_FC_START");
                        sendMessage(F_BLE_COM_FC_COMMAND_F11);
                    } else if (giStatus == F_BLE_COM_FC_START22) {
                        Logger.d(TAG, "F_BLE_COM_FC_START22");
                        sendMessage(F_BLE_COM_FC_COMMAND_F22);
                    }
                }
            }
        },delay);
    }

    public void connect(int connectTargetDeviceType, String deviceAddress) {
        bleManagerUtil.connect(connectTargetDeviceType, deviceAddress);
    }

    // 切断
    public void disconnect() {
        isConnected = false;
        bleManagerUtil.disconnect();
    }


    /**
     * @param message Message to transmit
     *                <p>
     *                Message is converted to specified format (if non-Ascii) and transmitted to remote device using
     *                TxChar characteristic. As BLE can only handle 20 byte data payloads, this function handles delivery
     *                of sequential packets until entire message is successfully transmitted. The selected line endings
     *                will be appended prior to transmission
     * @brief Handles delivery of message to connected device.
     * @note This function is called on a non-UI thread to avoid blocking user interaction.
     */
    public void sendMessage(String message) {

        // Send message on a separate thread so we don't hold up the UI
        class MessageSender implements Runnable {
            String message;

            private MessageSender(String string) {
                this.message = string;
            }

            @Override
            public void run() {
                Logger.d(TAG,"SendMessage start");
                gi_rxlength = 0;
                final int PACKET_SIZE = 20;
                BluetoothGatt s_mBluetoothGatt;        // @@@
                String error_msg = "";

                try {
                    // Convert our message to byte array in selected format
                    byte[] bMessage = message.getBytes("UTF-8");
                    bMessage = hex2string(bMessage); // Requires NumberFormatException
                    if (bMessage == null) {
                        // Invalid message
                        throw new NumberFormatException();
                    }

                    // We can only transmit in packets of 20 bytes
                    int packet_start = 0;
                    while (packet_start < bMessage.length) {

                        // Trim the packet length if we have less than 20 to send
                        int packet_end = (bMessage.length < packet_start + PACKET_SIZE) ? bMessage.length : packet_start + PACKET_SIZE;

                        // Construct and send this packet

                        byte[] chunk = new byte[packet_end - packet_start];
                        for (int i = 0; i < chunk.length; i++) {
                            chunk[i] = bMessage[i + packet_start];
                        }
                        TxChar.setValue(chunk);

                        s_mBluetoothGatt = bleManagerUtil.mBluetoothGatt;
                        if (s_mBluetoothGatt == null) {
                            throw new Exception(new Throwable());
                        }
                        if (!s_mBluetoothGatt.writeCharacteristic(TxChar)) {
                            throw new Exception(new Throwable());
                        }
                        packet_start += PACKET_SIZE;
                        Thread.sleep(10);   // Requires InterruptedException

                    }
                    Logger.i(TAG,"Tx:" + message);

                    // @Mode Change
                    switch (gi_status) {
                        case F_BLE_COM_RP_START:
                            gi_status = F_BLE_COM_RP_WAIT;
                            Logger.d(TAG,"F_BLE_COM_RP_WAIT:" + gi_status);
                            break;
                        case F_BLE_COM_RD_START:
                            gi_status = F_BLE_COM_RD_WAIT;
                            Logger.d(TAG,"F_BLE_COM_RD_WAIT:" + gi_status);
                            break;
                        case F_BLE_COM_FC_START:
                            gi_status = F_BLE_COM_FC_WAIT;
                            Logger.d(TAG,"F_BLE_COM_FC_WAIT:" + gi_status);
                            break;
                        case F_BLE_COM_FC_START22:
                            gi_status = F_BLE_COM_FC_WAIT22;
                            Logger.d(TAG,"F_BLE_COM_FC_WAIT22:" + gi_status);
                            break;
                        default:
                            // None
                            break;
                    }

                } catch (UnsupportedEncodingException e) {
                    Logger.w(TAG,e);
                } catch (InterruptedException e) {
                    Logger.w(TAG,e);
                } catch (NumberFormatException e) {
                    //error_msg = "Invalid message format";
                } catch (Exception e) {
                    //error_msg = "Failed to send data";
                }
                Logger.d(TAG,"SendMessage end");
            }
        }
        Thread thread = new Thread(new MessageSender(message));
        thread.start();
    }
    /**
     * @return Hex formatted string
     * @brief Converts a byte array of ascii to hexadecimal
     */
    public byte[] ascii2hex(byte[] bytes) {

        byte[] result = new byte[3 * bytes.length];
        int i = 0;
        for (byte b : bytes) {
            // Upper nibble
            byte un = (byte) ((b >> 4) & 0xF);
            result[i] = (byte) (un > 9 ? un + 0x37 : un + 0x30);
            // Lower nibble
            byte ln = (byte) (b & 0xF);
            result[i + 1] = (byte) (ln > 9 ? ln + 0x37 : ln + 0x30);
            result[i + 2] = (byte) ' ';
            i += 3;
        }
        return null;//result;                                                                                                    ;
    }
    /**
     * @return Ascii formatted string
     * @brief Converts a byte array of hexadecimal values to characters
     */
    private byte[] hex2string(byte[] bytes) {
        ArrayList <Byte> in = new ArrayList<>(bytes.length + 1);

        byte b;
        // Validate input
        for (int i = 0; i < bytes.length; i++) {
            b = getValidHex(bytes[i]);
            switch (b) {
                case (byte) 0xFF:
                    // Invalid character
                    return null;
                case (byte) 0xFE:
                    // Ignore character
                    break;
                default:
                    // Valid
                    in.add(Byte.valueOf(b));
            }
        }

        if ((in.size() & 1) == 1)
            in.add(0, Byte.valueOf("0"));

        // Construct bytes
        byte[] out = new byte[in.size() / 2];
        for (int i = 0; i < out.length; i++) {
            byte u = (byte) (in.get(i * 2) << 4);
            byte l = in.get(2 * i + 1);
            out[i] = (byte) (u + l);
        }

        return out;
    }

    private int fcWaitMode = 0;

    /**
     * Checks if a character is a valid hexadecimal character
     *
     * @param b Hexadecimal value
     * @return Ascii value of character, 0xFE if special character, 0xFF if invalid
     */
    private byte getValidHex(byte b) {
        if (b < '0') return (byte) 0xFE;
        if ((b - '0') <= '9' - '0') return (byte) (b - '0');
        if ((b - 'A') <= 'F' - 'A') return (byte) (b - 'A' + 10);
        if ((b - 'a') <= 'f' - 'a') return (byte) (b - 'a' + 10);
        return (byte) 0xFF;
    }
    /* @Rx Command Check */
    public void sub_rx_chk(byte[] rxdata) {

        try {
            // Append to current stream output
            sub_rx_data_gen(rxdata);

            // Mode
            int oldgiStatus = gi_status;
            switch (gi_status) {
                case F_BLE_COM_INIT:
                    // BLE Init
                    break;
                case F_BLE_COM_RP_WAIT:
                    // RP Command Send Wait
                    gi_status = fn_rx_rp_chk(rxdata);
                    break;
                case F_BLE_COM_RD_WAIT:
                    // RD Command Send Wait
                    gi_status = fn_rx_rd_chk(rxdata);
                    break;
                case F_BLE_COM_FC_WAIT:
                    gi_status = fn_rx_fc_chk(rxdata);
                    break;
                case F_BLE_COM_FC_WAIT22:
                    gi_status = fn_rx_fc_chk2(rxdata);
                    break;
                default:
                    // Others(Include Error)
                    gi_status = F_BLE_COM_RP_START;
                    break;
            }

            if (oldgiStatus == F_BLE_COM_RP_WAIT && gi_status == F_BLE_COM_FC_WAIT && fcWaitMode == 1) {
                return;
            }
            if (oldgiStatus != gi_status) {
                Logger.i(TAG,"chageStatus:" + gi_status);
                SendMessageFromCentral(gi_status);
            }
        } catch (IndexOutOfBoundsException e) {
            Logger.e(TAG,e);
        }
    }

    public void SendResponse() {

    }

    /* @Read Flame Generation */
    private void sub_rx_data_gen(byte[] rxdata) {
        int si_length;
        int si_iloop;
        si_length = rxdata.length;

        // Buffer Size Check
        if ((gi_rxlength + si_length) <= F_RX_BUFSIZE) {
            // None
        } else {
            si_length = F_RX_BUFSIZE - gi_rxlength;
        }

        if (si_length > 0) {
            for (si_iloop = 0; si_iloop < si_length; si_iloop++) {
                gb_rxdat[si_iloop + gi_rxlength] = rxdata[si_iloop];
            }

            gi_rxlength += si_length;
        }
    }

    /* @RP Command Check */
    private int fn_rx_rp_chk(byte[] rxdata) {
        Logger.d(TAG,"fn_rx_rp_chk");
        int si_ret;
        byte sb_mode;

        for (byte b: rxdata) {
            Logger.d(TAG,"%s, ", Byte.toString(b));
        }

        si_ret = F_BLE_COM_RP_WAIT;

        //  01 72 70 02
        //
        //  01 72 70 02
        //
        boolean go = false;
        if (rxdata.length  == 4 && rxdata[0] == 2 && rxdata[1] == 14 && rxdata[2] == -11 && rxdata[3] == 4) {
            go = true;
        }
        if (rxdata.length  == 4 && rxdata[0] == 1 && rxdata[1] == 102 && rxdata[2] == 99 && rxdata[3] == 3) {
            // nor rp  FC command
            fcWaitMode = 1;
            return si_ret = F_BLE_COM_FC_WAIT;
        }

        // Command Check
        Logger.d(TAG,"RP_RENGTH=" + gi_rxlength);
        if (gi_rxlength == F_RX_RP_LENGTH || go) {
            if ((gb_rxdat[F_RX_COMMAND_POS] == F_RP_COMMAND_MSB) && (gb_rxdat[(F_RX_COMMAND_POS + 1)] == F_RP_COMMAND_LSB)) {
                sb_mode = gb_rxdat[F_RX_RP_MODE_POS];
                switch (sb_mode) {
                    case (byte) 0x07:
                        // Rest 3
                        listener.onUpdateTBVCalc("3");
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x08:
                        // Rest 2
                        listener.onUpdateTBVCalc("2");
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x09:
                        // Rest 1
                        listener.onUpdateTBVCalc("1");
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x0A:
                        // 計測
                        listener.onUpdateTBVCalc("Go");
                        // Blow
                        gf_result_flg = false;
                        si_ret = F_BLE_COM_RP_START;
                        listener.onStartMeasurement();
                        break;
                    case (byte) 0x0B:
                        // Blow After
                        listener.onUpdateTBVCalc("Blow...");
                        gf_result_flg = false;
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x0C:
                        // Result
                        if (gf_result_flg == false) {
                            si_ret = F_BLE_COM_RD_START;
                        } else {
                            si_ret = F_BLE_COM_RP_START;
                        }
                        break;
                    case (byte) 0x0D:
                        // Wait
                        listener.onUpdateTBVCalc("Wait");
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x0E:
                        // Ready
                        listener.onUpdateTBVCalc("Ready? 測定開始待ち状態 0x0E");
                        si_ret = F_BLE_COM_RP_START;
                        break;
                    case (byte) 0x11:
                        // Error
                        if (gf_result_flg == false) {
                            si_ret = F_BLE_COM_RD_START;
                            Logger.i(TAG, "ERROR 0x11 si_ret = F_BLE_COM_RD_START");
                        } else {
                            si_ret = F_BLE_COM_RP_START;
                            Logger.i(TAG, "ERROR 0x11 si_ret = F_BLE_COM_RP_START");
                        }
                        // "エラー 0x11"
                        // 呼気エラー
                        listener.onMeasurementError("エラー 0x11");
                        break;
                    case (byte) 0x12:
                        // Failed
                        listener.onBreakDownError("BreakDown");
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "ERROR 0x12 si_ret = F_BLE_COM_RP_START");
                        break;
                    case (byte) 0x14:
                        listener.onLowBatteryError("Low Battery");
                        // Low Battery
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "ERROR 0x14 si_ret = F_BLE_COM_RP_START");
                        break;
                    case (byte) 0x15:
                        // Calc
                        listener.onUpdateTBVCalc("Calculationg");
                        gf_result_flg = false;
                        si_ret = F_BLE_COM_RP_START;
                        //Logger.d(TAG, "0x15 si_ret = F_BLE_COM_RP_START");
                        break;
                    case (byte) 0x1F:
                        listener.onOverUsedError("Over Used");
                        // Excess usage count
                        gf_result_flg = false;
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "ERROR 0x1F si_ret = F_BLE_COM_RP_START");
                        break;
                    case (byte) 0x20:
                        listener.onPowerOff("OFF");
                        // Power Down
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "ERROR 0x20 si_ret = F_BLE_COM_RP_START");
                        break;
                    case (byte) 0x21:
                        listener.onUpdateTBVCalc("Data");
                        // Result Data Screen
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "DATA 0x21 si_ret = F_BLE_COM_RP_START");
                        break;
                    default:
                        // Others
                        si_ret = F_BLE_COM_RP_START;
                        Logger.d(TAG, "OTHERS 0x20 si_ret = F_BLE_COM_RP_START");
                        break;
                }
            } else {
                //Logger.e(TAG,"RP Error");
                si_ret = F_BLE_COM_RP_START;
            }
        } else {
            if (gi_rxlength < F_RX_RP_LENGTH) {
                /* Receiving */
                si_ret = F_BLE_COM_RP_WAIT;
                Logger.d(TAG,"gi_rxlength < F_RX_RP_LENGTH,  si_ret ==  F_BLE_COM_RP_WAIT");
            } else {
                Logger.e(TAG,"RP Length Error");
                si_ret = F_BLE_COM_RP_START;
                Logger.d(TAG,"gi_rxlength < F_RX_RP_LENGTH,  si_ret = F_BLE_COM_RP_START;");
            }
        }

        return si_ret;
    }

    /**
     * BLEに戻す場合のfc コマンドチェック
     * @param rxdata　コマンドのbyte配列
     * @return 次回モード
     */
    private int fn_rx_fc_chk(byte[] rxdata) {
        Logger.d(TAG,"fn_rx_fc_chk");
        int si_ret = F_BLE_COM_FC_WAIT;

        for (byte b: rxdata) {
            Logger.d(TAG,"%s, ", Byte.toString(b));
        }

        // 01  72  70 02       rp 上位
        // 01 114 112 02

        // 2  14  -11  4      rp 下部
        // 2   E  F5   4
        // 動作モード、進行状況、チェックサム

        // 01 102 99  3     fc
        //
        if (fcWaitMode == 0) {
            if (rxdata.length > 3 && rxdata[0] == 1 && rxdata[1] == 102 && rxdata[2] == 99 && rxdata[3] == 3) {
                // fcコマンド
                fcWaitMode = 1;
            }

            // FALC-31S対応
            if (gi_rxlength > 3 && gb_rxdat[0] == 1 && gb_rxdat[1] == 102 && gb_rxdat[2] == 99 && gb_rxdat[3] == 3) {
                // fcコマンド
                fcWaitMode = 1;
            }

            if (rxdata.length > 3 && rxdata[0] == 1 && rxdata[1] == 114 && rxdata[2] == 112 && rxdata[3] == 2) {
                // RP上位が入ってくる場合があった
                si_ret = F_BLE_COM_RP_WAIT;
                return si_ret;
            }
        } else if (fcWaitMode == 1) {
            // FALC-31S対応追加
            if (rxdata.length == 5 || gi_rxlength == 9) {
                // 49    05  32  35 4
                // 0x31  05  20  23 4   実行完了 本体動作モード リアルタイム測定進行状況 チェックサム 4

//                if (rxdata[0] ==49 && rxdata[1] == 2) {
//                    //Logger.i(TAG, "------FC失敗");
//                }

                if(!StringUtil.isNullOrEmpty(strAlcoholValue)) {
                    // 測定値あれば成功
                    listener.onGetDeviceInfo(strAlcoholValue);
                    strAlcoholValue = "";
                }
                fcWaitMode = 0;
                si_ret = F_BLE_COM_RP_START;
            }
        }
        return si_ret;
    }


    /**
     * RDYに戻す場合のfc コマンドチェック
     * @param rxdata　コマンドのbyte配列
     * @return 次回モード
     */
    private int fn_rx_fc_chk2(byte[] rxdata) {
        Logger.d(TAG, "fn_rx_fc_chk2");
        for (byte b: rxdata) {
            Logger.d(TAG,"%s, ", Byte.toString(b));
        }
        int si_ret = F_BLE_COM_FC_WAIT22;
        if (fcWaitMode == 0) {
            if (rxdata[0] == 1 && rxdata[1] == 102 && rxdata[2] == 99 && rxdata[3] == 3) {
                // fcコマンド
                fcWaitMode = 1;
            }
        } else if (fcWaitMode == 1) {
            if (rxdata.length == 5) {
                if (rxdata.length == 5) {
                    // 49    05  32  35 4
                    // 0x31  05  20  23 4   実行完了 本体動作モード リアルタイム測定進行状況 チェックサム 4

                    if (rxdata[0] == 49 && rxdata[1] == 2) {
                        Logger.i(TAG, "RDYに戻る");
                        si_ret = F_BLE_COM_RP_START;
                    }

                    if (!StringUtil.isNullOrEmpty(strAlcoholValue)) {
                        // 測定値あれば成功
                        listener.onGetDeviceInfo(strAlcoholValue);
                        strAlcoholValue = "";
                    }
                    fcWaitMode = 0;
                    si_ret = F_BLE_COM_RP_START;
                }
            }
        }
        return si_ret;
    }

    /* @RD Command Check */
    private int fn_rx_rd_chk(byte[] rxdata) {
        Logger.d(TAG,"fn_rx_rd_chk");
        int si_ret;
        byte sb_data;
        short ss_data;
        String str_msg;

        si_ret = F_BLE_COM_RD_WAIT;
        for (byte b: rxdata) {
            Logger.d(TAG,"%s, ", Byte.toString(b));
        }

        if (rxdata[0] == 1 && rxdata[1] == 101 && rxdata[2] == 114 && rxdata[3] == 3) {
            // er コマンドの reply
            // 1     101   114  3
            // 0x01 0x65   0x72 0x03
            si_ret = F_BLE_COM_RD_START;
            return si_ret;
        }

        // 1    114   100    22
        // 0x01 0x72 0x64, 0x16

        // 1, 114, 100, 22, -1, -1, 0, -1, -1, 5, 3, 74, -1, -1, -1, -1, -1, -1, 45, 4
        // 1, 114, 100, 22, -1, -1, 0,         5, 3, 75, -1, -1, -1, -1, -1, -1, 46  4

        boolean go = false;
        if (gi_rxlength >= 24 && rxdata[rxdata.length-1] == 4) {
            go = true;
        }

        // Command Check
        Logger.d(TAG,"RD_LENGTH="+gi_rxlength);
        if (gi_rxlength == F_RX_RD_LENGTH || go) {
            // 0x72, 0x64
            if ((gb_rxdat[F_RX_COMMAND_POS] == F_RD_COMMAND_MSB) && (gb_rxdat[(F_RX_COMMAND_POS + 1)] == F_RD_COMMAND_LSB)) {
                sb_data = gb_rxdat[F_RX_RD_DATA_POS];
                str_msg = "";

                // Change Range from (-128 to 127) to (0 to 255)
                if (sb_data >= 0) {
                    ss_data = (short) sb_data;
                } else {
                    ss_data = (short) (256 + (short) sb_data);
                }

                // Message
                if ((ss_data >= 0) && (ss_data < (short) 0xE0)) {
                    if (ss_data >= (short) 100) {
                        str_msg = "1.00";
                    } else {
                        str_msg = "0.";
                        str_msg += String.format("%1$02d", ss_data);
                    }

                    Logger.d(TAG,"測定結果表示");
                    //str_msg += "[mg/L]";
                    // 0x0C 測定結果表示状態");
                    strAlcoholValue = str_msg;
                    // BLE に戻す
                    si_ret = F_BLE_COM_FC_START;

                    return si_ret;
                } else {
                    // Error
                    gf_result_flg = true;
                    si_ret = F_BLE_COM_RP_START;
                }
            } else {
                //Logger.e(TAG,"RD Error");
                //si_ret = F_BLE_COM_RP_START;
                // 失敗の場合もエラーに戻す
            }
        } else {
            if (gi_rxlength < F_RX_RD_LENGTH) {
                /* Receiving */
                si_ret = F_BLE_COM_RD_WAIT;
            } else {
                Logger.e(TAG,"RD Length Error");
                si_ret = F_BLE_COM_RP_START;
            }
        }

        return si_ret;
    }

    // @@@@@
    public void DescriptorDevice(BluetoothGattCharacteristic uRxChar, UUID ucccd) {
        bleManagerUtil.DescriptorDevice(uRxChar, ucccd);
    }

    // @@@@@
    public void NotificationDisable(BluetoothGattCharacteristic uRxChar, UUID ucccd) {
        bleManagerUtil.NotificationDisable(uRxChar, ucccd);
    }
}