package jp.agentec.abook.abv.ui.common.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.List;

import jp.agentec.abook.abv.launcher.android.R;

public class SimpleTextViewAdapter extends BaseAdapter {
    private List<String> mListItem;
    private LayoutInflater mInflater;

    public SimpleTextViewAdapter(Context context, List<String> listItem) {
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        this.mListItem = listItem;
    }

    @Override
    public int getCount() {
        return mListItem.size();
    }

    @Override
    public Object getItem(int position) {
        return mListItem.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.item_simple_textview, null);
        }
        TextView textView = convertView.findViewById(R.id.tv_item);
        textView.setText(mListItem.get(position));
        return convertView;
    }
}
