package jp.agentec.abook.abv.ui.viewer.activity.theta;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.Bundle;

import com.theta.helper.ThetaHelper;

import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVUIActivity;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

/**
 * Theta関連共通クラス
 * @version 1.2.300
 * @since 2020/06/18
 * @author 金鎭星
 */
public class ThetaActivity extends ABVUIActivity {
    private static final String TAG = "ThetaActivity";
    private WifiManager mWifiManager;
    protected ThetaHelper mThetaHelper = new ThetaHelper(this);
    private int mWifiScanType;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mWifiManager =  (WifiManager)getApplicationContext().getSystemService(Context.WIFI_SERVICE);
    }

    /**
     * Wifiスキャンするブロードキャストリスナークラス
     */
    BroadcastReceiver wifiReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            unregisterReceiver(wifiReceiver);
            boolean isConnected = mThetaHelper.checkThetaCameraWifiConnected(mWifiManager);
            closeProgressPopup();
            //THETAカメラ画面閉じる
            if (mWifiScanType == Constant.WifiScanType.CloseCameraActivity) {
                if (isConnected) {
                    mThetaHelper.disConnectThetaCameraWifi(mWifiManager);
                }
                mThetaHelper.appConnectedWifiDefault();
                finish();
            } else if (mWifiScanType == Constant.WifiScanType.ThetaConnectError) { //THETAカメラと通信エラー共通
                if (isConnected) {
                    thetaCameraWifiConnected();
                } else {
                    AlertDialogUtil.showAlertDialog(ThetaActivity.this, R.string.app_name, R.string.msg_theta_wifi_disconnect, true, new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            //Thetaカメラ関連Activity終了
                            ActivityHandlingHelper.getInstance().finishAllThetaActivity();
                            mThetaHelper.appConnectedWifiDefault();
                        }
                    });
                }
            }
        }
    };

    /**
     * Thetaカメラと通信失敗時、共通メソッド
     * @param errorMessageResourceId エラーメッセージリソースID
     */
    protected void thetaConnectError(int errorMessageResourceId) {
        AlertDialogUtil.showAlertDialog(this, R.string.app_name, errorMessageResourceId, true, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                changeProgressPopup(getString(R.string.progress));
                //現在接続状態なのかチェック
                registerReceiver(wifiReceiver, new IntentFilter(WifiManager.SCAN_RESULTS_AVAILABLE_ACTION));
                mWifiManager.startScan();
                mWifiScanType = Constant.WifiScanType.ThetaConnectError;
            }
        });
    }

    /**
     * THETAカメラ画面から閉じるボタンタップ時にTHETAカメラのWi-Fi機能を無効にするため、
     * Wi-Fiが接続状態かチェックする。
     */
    protected void closeThetaCameraActivity() {
        Logger.i(TAG,"closeThetaCameraActivity");
        showProgressPopup();
        //現在接続状態なのかチェック
        registerReceiver(wifiReceiver, new IntentFilter(WifiManager.SCAN_RESULTS_AVAILABLE_ACTION));
        mWifiManager.startScan();
        mWifiScanType = Constant.WifiScanType.CloseCameraActivity;
    }

    /**
     * 子クラスで定義
     */
    protected void thetaCameraWifiConnected() {}
}
