/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.graphics.Rect;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oz.lottie.PerformanceTracker;
import oz.lottie.custom.SparseArrayCompat;
import oz.lottie.model.Marker;
import oz.lottie.model.layer.Layer;
import oz.lottie.utils.Logger;

public class LottieComposition {
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    private final HashSet warnings = new HashSet();
    private Map precomps;
    private Map images;
    private Map fonts;
    private List markers;
    private SparseArrayCompat characters;
    private LongSparseArray layerMap;
    private List layers;
    private Rect bounds;
    private float startFrame;
    private float endFrame;
    private float frameRate;
    private boolean hasDashPattern;
    private int maskAndMatteCount = 0;

    public void init(Rect rect, float f2, float f3, float f4, List list, LongSparseArray longSparseArray, Map map, Map map2, SparseArrayCompat sparseArrayCompat, Map map3, List list2) {
        this.bounds = rect;
        this.startFrame = f2;
        this.endFrame = f3;
        this.frameRate = f4;
        this.layers = list;
        this.layerMap = longSparseArray;
        this.precomps = map;
        this.images = map2;
        this.characters = sparseArrayCompat;
        this.fonts = map3;
        this.markers = list2;
    }

    public void addWarning(String string) {
        Logger.warning(string);
        this.warnings.add(string);
    }

    public void setHasDashPattern(boolean bl) {
        this.hasDashPattern = bl;
    }

    public void incrementMatteOrMaskCount(int n) {
        this.maskAndMatteCount += n;
    }

    public boolean hasDashPattern() {
        return this.hasDashPattern;
    }

    public int getMaskAndMatteCount() {
        return this.maskAndMatteCount;
    }

    public ArrayList getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean bl) {
        this.performanceTracker.setEnabled(bl);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    public Layer layerModelForId(long l) {
        return (Layer)this.layerMap.get(l);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public float getDuration() {
        return (long)(this.getDurationFrames() / this.frameRate * 1000.0f);
    }

    public float getStartFrame() {
        return this.startFrame;
    }

    public float getEndFrame() {
        return this.endFrame;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public List getLayers() {
        return this.layers;
    }

    public List getPrecomps(String string) {
        return (List)this.precomps.get(string);
    }

    public SparseArrayCompat getCharacters() {
        return this.characters;
    }

    public Map getFonts() {
        return this.fonts;
    }

    public List getMarkers() {
        return this.markers;
    }

    public Marker getMarker(String string) {
        int n = this.markers.size();
        int n2 = 0;
        while (n2 < this.markers.size()) {
            Marker marker = (Marker)this.markers.get(n2);
            if (marker.matchesName(string)) {
                return marker;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public Map getImages() {
        return this.images;
    }

    public float getDurationFrames() {
        return this.endFrame - this.startFrame;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            stringBuilder.append(layer.toString("\t"));
        }
        return stringBuilder.toString();
    }
}

