/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec.encoder;

import oz.util.barcode.aztec.encoder.Token;
import oz.util.barcode.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short binaryShiftStart;
    private final short binaryShiftByteCount;

    BinaryShiftToken(Token token, int n, int n2) {
        super(token);
        this.binaryShiftStart = (short)n;
        this.binaryShiftByteCount = (short)n2;
    }

    @Override
    public void appendTo(BitArray bitArray, byte[] byArray) {
        int n = 0;
        while (n < this.binaryShiftByteCount) {
            if (n == 0 || n == 31 && this.binaryShiftByteCount <= 62) {
                bitArray.appendBits(31, 5);
                if (this.binaryShiftByteCount > 62) {
                    bitArray.appendBits(this.binaryShiftByteCount - 31, 16);
                } else if (n == 0) {
                    bitArray.appendBits(Math.min(this.binaryShiftByteCount, 31), 5);
                } else {
                    bitArray.appendBits(this.binaryShiftByteCount - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.binaryShiftStart + n], 8);
            ++n;
        }
    }

    public String toString() {
        return "<" + this.binaryShiftStart + "::" + (this.binaryShiftStart + this.binaryShiftByteCount - 1) + '>';
    }
}

