/*
 * Decompiled with CFR 0.152.
 */
package oz.util.pdf;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.pdf.PdfRenderer;
import android.os.ParcelFileDescriptor;
import java.io.File;

public class OZPDFRenderer_Platform {
    private PdfRenderer mRenderer;
    private PdfRenderer.Page mLoadedPage;

    public void Open(File file) {
        try {
            this.mRenderer = new PdfRenderer(ParcelFileDescriptor.open((File)file, (int)0x10000000));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void Close() {
        if (this.isOpen()) {
            this.ClosePage();
            this.mRenderer.close();
            this.mRenderer = null;
        }
    }

    public boolean isOpenPage() {
        return this.mLoadedPage != null;
    }

    public boolean isOpen() {
        return this.mRenderer != null;
    }

    public int getPageCount() {
        if (this.isOpen()) {
            return this.mRenderer.getPageCount();
        }
        return 0;
    }

    public void OpenPage(int n) {
        this.mLoadedPage = this.mRenderer.openPage(n);
    }

    public void ClosePage() {
        if (this.isOpenPage()) {
            this.mLoadedPage.close();
            this.mLoadedPage = null;
        }
    }

    public int getPageWidth() {
        if (this.isOpenPage()) {
            return this.mLoadedPage.getWidth();
        }
        return 0;
    }

    public int getPageHeight() {
        if (this.isOpenPage()) {
            return this.mLoadedPage.getHeight();
        }
        return 0;
    }

    public void pageRender(Bitmap bitmap, Rect rect, Matrix matrix) {
        if (this.isOpenPage()) {
            this.mLoadedPage.render(bitmap, rect, matrix, 1);
        }
    }
}

