/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.edit;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;
import oz.viewer.ui.edit.ACanvasImageView;
import oz.viewer.ui.edit.AControllerObject;
import oz.viewer.ui.edit.AEditableBaseView;

public class AControllerImage
extends AControllerObject {
    private Bitmap m_bitmap;
    private ACanvasImageView m_imageView;

    public AControllerImage(Context context, JSONObject jSONObject, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView, 0);
        this.parse(jSONObject);
    }

    public AControllerImage(Context context, Bitmap bitmap, AEditableBaseView aEditableBaseView) {
        super(context, aEditableBaseView, 0);
        this.getBaseView().setDirty();
        this.setBitmap(bitmap);
        this.createImageView();
    }

    private void setImageView(ACanvasImageView aCanvasImageView) {
        this.m_imageView = aCanvasImageView;
    }

    public ACanvasImageView getImageView() {
        return this.m_imageView;
    }

    private void setBitmap(Bitmap bitmap) {
        this.m_bitmap = bitmap;
    }

    public Bitmap getBitmap() {
        return this.m_bitmap;
    }

    private void createImageView() {
        this.createImageView(this.getBitmap());
    }

    private void createImageView(Matrix matrix, RectF rectF) {
        this.createImageView(this.getBitmap(), matrix, rectF);
    }

    private void createImageView(Bitmap bitmap) {
        this.setImageView(new ACanvasImageView(this.getContext(), bitmap, this.getBaseView(), this));
    }

    private void createImageView(Bitmap bitmap, Matrix matrix, RectF rectF) {
        this.setImageView(new ACanvasImageView(this.getContext(), bitmap, this.getBaseView(), this, matrix, rectF));
    }

    public void setProperties(RectF rectF, double d2, Bitmap bitmap) {
        this.setRect(rectF);
        this.setItemRotation(d2);
        this.setBitmap(bitmap);
    }

    public void parse(JSONObject jSONObject) {
        block12: {
            try {
                if (jSONObject == null) break block12;
                if (jSONObject.getString("type").equalsIgnoreCase("image")) {
                    Object object;
                    String string;
                    String string2 = jSONObject.getString("rect");
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        string3 = string3.toLowerCase();
                        string3 = string3.trim();
                        stringArray[n++] = string3;
                    }
                    if (stringArray.length != 4) {
                        throw new Exception();
                    }
                    float f2 = Float.parseFloat(stringArray[0]);
                    float f3 = Float.parseFloat(stringArray[1]);
                    float f4 = Float.parseFloat(stringArray[2]);
                    float f5 = Float.parseFloat(stringArray[3]);
                    this.setRect(f2, f3, f4, f5);
                    String string4 = jSONObject.getString("realrect");
                    stringTokenizer = new StringTokenizer(string4, ",");
                    stringArray = new String[stringTokenizer.countTokens()];
                    n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                        string = string.toLowerCase();
                        string = string.trim();
                        stringArray[n++] = string;
                    }
                    if (stringArray.length != 4) {
                        throw new Exception();
                    }
                    f2 = Float.parseFloat(stringArray[0]);
                    f3 = Float.parseFloat(stringArray[1]);
                    f4 = Float.parseFloat(stringArray[2]);
                    f5 = Float.parseFloat(stringArray[3]);
                    string = new RectF(f2, f3, f4, f5);
                    String string5 = jSONObject.getString("matrix");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ",");
                    String[] stringArray2 = new String[stringTokenizer2.countTokens()];
                    n = 0;
                    while (stringTokenizer2.hasMoreTokens()) {
                        object = stringTokenizer2.nextToken();
                        object = ((String)object).toLowerCase();
                        object = ((String)object).trim();
                        stringArray2[n++] = object;
                    }
                    if (stringArray2.length != 4) {
                        throw new Exception();
                    }
                    object = new float[9];
                    object[0] = Float.parseFloat(stringArray2[0]);
                    object[4] = Float.parseFloat(stringArray2[1]);
                    object[1] = Float.parseFloat(stringArray2[2]);
                    object[3] = Float.parseFloat(stringArray2[3]);
                    object[2] = 0.0f;
                    object[5] = 0.0f;
                    object[6] = 0.0f;
                    object[7] = 0.0f;
                    object[8] = 1.0f;
                    Matrix matrix = new Matrix();
                    matrix.reset();
                    matrix.setValues((float[])object);
                    String string6 = jSONObject.getString("value");
                    if (!string6.isEmpty()) {
                        String string7 = string6;
                        byte[] byArray = Base64.decode((byte[])string7.getBytes(), (int)0);
                        this.setBitmap(BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length));
                        this.createImageView(matrix, (RectF)string);
                    } else if (this.getBaseView().getICImagePickerWnd().bitmap != null) {
                        this.setBitmap(this.getBaseView().getICImagePickerWnd().bitmap);
                    }
                    break block12;
                }
                throw new Exception("not ImageType");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public JSONObject serialize() {
        String string = "";
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"image");
            string = String.format(Locale.ENGLISH, "%f,%f,%f,%f", Float.valueOf((this.getRect().left - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().top - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().right - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf((this.getRect().bottom - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW));
            jSONObject.put("rect", (Object)string);
            string = String.format(Locale.ENGLISH, "%f,%f,%f,%f", Float.valueOf(((float)this.getImageView().getView().getLeft() - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf(((float)this.getImageView().getView().getTop() - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW), Float.valueOf(((float)this.getImageView().getView().getRight() - this.getBaseView().getDstRect().left) * this.getBaseView().m_canvasW), Float.valueOf(((float)this.getImageView().getView().getBottom() - this.getBaseView().getDstRect().top) * this.getBaseView().m_canvasW));
            jSONObject.put("realrect", (Object)string);
            Matrix matrix = this.getImageView().getView().getImageMatrix();
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            string = String.format(Locale.ENGLISH, "%f,%f,%f,%f", Float.valueOf(fArray[0]), Float.valueOf(fArray[4]), Float.valueOf(fArray[1]), Float.valueOf(fArray[3]));
            jSONObject.put("matrix", (Object)string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.getBitmap().compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string2 = Base64.encodeToString((byte[])byArray, (int)0);
            jSONObject.put("value", (Object)string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }
}

