/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.metrics;

import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class RecordUserAction {
    private static boolean sIsDisabledForTests = false;

    @VisibleForTesting
    public static void disableForTests() {
        sIsDisabledForTests = true;
    }

    public static void record(final String action) {
        if (sIsDisabledForTests) {
            return;
        }
        if (ThreadUtils.runningOnUiThread()) {
            RecordUserAction.nativeRecordUserAction(action);
            return;
        }
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RecordUserAction.nativeRecordUserAction(action);
            }
        });
    }

    private static native void nativeRecordUserAction(String var0);
}

