/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.web_contents_delegate_android;

import android.content.Context;
import android.graphics.Point;
import android.graphics.RectF;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.components.web_contents_delegate_android.R;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;

class ValidationMessageBubble {
    private PopupWindow mPopup;

    @CalledByNative
    private static ValidationMessageBubble createAndShow(ContentViewCore contentViewCore, int anchorX, int anchorY, int anchorWidth, int anchorHeight, String mainText, String subText) {
        RectF anchorPixInScreen = ValidationMessageBubble.makePixRectInScreen(contentViewCore, anchorX, anchorY, anchorWidth, anchorHeight);
        return new ValidationMessageBubble(contentViewCore, anchorPixInScreen, mainText, subText);
    }

    private ValidationMessageBubble(ContentViewCore contentViewCore, RectF anchor, String mainText, String subText) {
        ViewGroup root = (ViewGroup)View.inflate((Context)contentViewCore.getContext(), (int)R.layout.validation_message_bubble, null);
        this.mPopup = new PopupWindow((View)root);
        ValidationMessageBubble.updateTextViews(root, mainText, subText);
        this.measure(contentViewCore.getRenderCoordinates());
        Point origin = this.adjustWindowPosition(contentViewCore, (int)(anchor.centerX() - this.getAnchorOffset()), (int)anchor.bottom);
        this.mPopup.showAtLocation((View)contentViewCore.getContainerView(), 0, origin.x, origin.y);
    }

    @CalledByNative
    private void close() {
        if (this.mPopup == null) {
            return;
        }
        this.mPopup.dismiss();
        this.mPopup = null;
    }

    @CalledByNative
    private void setPositionRelativeToAnchor(ContentViewCore contentViewCore, int anchorX, int anchorY, int anchorWidth, int anchorHeight) {
        RectF anchor = ValidationMessageBubble.makePixRectInScreen(contentViewCore, anchorX, anchorY, anchorWidth, anchorHeight);
        Point origin = this.adjustWindowPosition(contentViewCore, (int)(anchor.centerX() - this.getAnchorOffset()), (int)anchor.bottom);
        this.mPopup.update(origin.x, origin.y, this.mPopup.getWidth(), this.mPopup.getHeight());
    }

    private static RectF makePixRectInScreen(ContentViewCore contentViewCore, int anchorX, int anchorY, int anchorWidth, int anchorHeight) {
        RenderCoordinates coordinates = contentViewCore.getRenderCoordinates();
        float yOffset = ValidationMessageBubble.getWebViewOffsetYPixInScreen(contentViewCore);
        return new RectF(coordinates.fromLocalCssToPix(anchorX), coordinates.fromLocalCssToPix(anchorY) + yOffset, coordinates.fromLocalCssToPix(anchorX + anchorWidth), coordinates.fromLocalCssToPix(anchorY + anchorHeight) + yOffset);
    }

    private static float getWebViewOffsetYPixInScreen(ContentViewCore contentViewCore) {
        int[] location = new int[2];
        contentViewCore.getContainerView().getLocationOnScreen(location);
        return (float)location[1] + contentViewCore.getRenderCoordinates().getContentOffsetYPix();
    }

    private static void updateTextViews(ViewGroup root, String mainText, String subText) {
        ((TextView)root.findViewById(R.id.main_text)).setText((CharSequence)mainText);
        TextView subTextView = (TextView)root.findViewById(R.id.sub_text);
        if (!TextUtils.isEmpty((CharSequence)subText)) {
            subTextView.setText((CharSequence)subText);
        } else {
            ((ViewGroup)subTextView.getParent()).removeView((View)subTextView);
        }
    }

    private void measure(RenderCoordinates coordinates) {
        this.mPopup.setHeight(-2);
        this.mPopup.setWidth(-2);
        this.mPopup.getContentView().setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.mPopup.getContentView().measure(View.MeasureSpec.makeMeasureSpec((int)coordinates.getLastFrameViewportWidthPixInt(), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)coordinates.getLastFrameViewportHeightPixInt(), (int)Integer.MIN_VALUE));
    }

    private float getAnchorOffset() {
        View root = this.mPopup.getContentView();
        int width = root.getMeasuredWidth();
        int arrowWidth = root.findViewById(R.id.arrow_image).getMeasuredWidth();
        return ApiCompatibilityUtils.isLayoutRtl(root) ? (float)(width * 3 / 4 - arrowWidth / 2) : (float)(width / 4 + arrowWidth / 2);
    }

    private Point adjustWindowPosition(ContentViewCore contentViewCore, int x, int y) {
        RenderCoordinates coordinates = contentViewCore.getRenderCoordinates();
        int viewWidth = coordinates.getLastFrameViewportWidthPixInt();
        int viewBottom = (int)ValidationMessageBubble.getWebViewOffsetYPixInScreen(contentViewCore) + coordinates.getLastFrameViewportHeightPixInt();
        int width = this.mPopup.getContentView().getMeasuredWidth();
        int height = this.mPopup.getContentView().getMeasuredHeight();
        if (x < 0) {
            x = 0;
        } else if (x + width > viewWidth) {
            x = viewWidth - width;
        }
        if (y + height > viewBottom) {
            y = viewBottom - height;
        }
        return new Point(x, y);
    }
}

