/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.os.Process;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.NetworkChangeNotifierAutoDetect;
import org.chromium.net.RegistrationPolicyAlwaysRegister;

@JNINamespace(value="content")
class BackgroundSyncNetworkObserver
implements NetworkChangeNotifierAutoDetect.Observer {
    private static final String TAG = "cr_BgSyncNetObserver";
    private NetworkChangeNotifierAutoDetect mNotifier;
    private Context mContext;
    private static BackgroundSyncNetworkObserver sInstance = null;
    private List<Long> mNativePtrs;

    private BackgroundSyncNetworkObserver(Context ctx) {
        ThreadUtils.assertOnUiThread();
        this.mContext = ctx;
        this.mNativePtrs = new ArrayList<Long>();
    }

    private static boolean canCreateObserver(Context ctx) {
        return ApiCompatibilityUtils.checkPermission(ctx, "android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid()) == 0;
    }

    @CalledByNative
    private static BackgroundSyncNetworkObserver createObserver(Context ctx, long nativePtr) {
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new BackgroundSyncNetworkObserver(ctx);
        }
        sInstance.registerObserver(nativePtr);
        return sInstance;
    }

    private void registerObserver(long nativePtr) {
        ThreadUtils.assertOnUiThread();
        if (!BackgroundSyncNetworkObserver.canCreateObserver(this.mContext)) {
            RecordHistogram.recordBooleanHistogram("BackgroundSync.NetworkObserver.HasPermission", false);
            return;
        }
        if (this.mNotifier == null) {
            this.mNotifier = new NetworkChangeNotifierAutoDetect(this, this.mContext, new RegistrationPolicyAlwaysRegister());
            RecordHistogram.recordBooleanHistogram("BackgroundSync.NetworkObserver.HasPermission", true);
        }
        this.mNativePtrs.add(nativePtr);
        this.nativeNotifyConnectionTypeChanged(nativePtr, this.mNotifier.getCurrentConnectionType(this.mNotifier.getCurrentNetworkState()));
    }

    @CalledByNative
    private void removeObserver(long nativePtr) {
        ThreadUtils.assertOnUiThread();
        this.mNativePtrs.remove(nativePtr);
        if (this.mNativePtrs.size() == 0 && this.mNotifier != null) {
            this.mNotifier.destroy();
            this.mNotifier = null;
        }
    }

    @Override
    public void onConnectionTypeChanged(int newConnectionType) {
        ThreadUtils.assertOnUiThread();
        for (Long nativePtr : this.mNativePtrs) {
            this.nativeNotifyConnectionTypeChanged(nativePtr, newConnectionType);
        }
    }

    @Override
    public void onMaxBandwidthChanged(double maxBandwidthMbps) {
    }

    @Override
    public void onNetworkConnect(int netId, int connectionType) {
    }

    @Override
    public void onNetworkSoonToDisconnect(int netId) {
    }

    @Override
    public void onNetworkDisconnect(int netId) {
    }

    @Override
    public void purgeActiveNetworkList(int[] activeNetIds) {
    }

    @NativeClassQualifiedName(value="BackgroundSyncNetworkObserverAndroid::Observer")
    private native void nativeNotifyConnectionTypeChanged(long var1, int var3);
}

