/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.view.accessibility.AccessibilityNodeInfo;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.accessibility.BrowserAccessibilityManager;

@JNINamespace(value="content")
@TargetApi(value=19)
public class KitKatBrowserAccessibilityManager
extends BrowserAccessibilityManager {
    private String mSupportedHtmlElementTypes;

    KitKatBrowserAccessibilityManager(long nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        super(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
        this.mSupportedHtmlElementTypes = this.nativeGetSupportedHtmlElementTypes(nativeBrowserAccessibilityManagerAndroid);
    }

    @Override
    protected void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo node, boolean isRoot, boolean isEditableText, String roleDescription) {
        Bundle bundle = node.getExtras();
        bundle.putCharSequence("AccessibilityNodeInfo.roleDescription", (CharSequence)roleDescription);
        if (isRoot) {
            bundle.putCharSequence("ACTION_ARGUMENT_HTML_ELEMENT_STRING_VALUES", (CharSequence)this.mSupportedHtmlElementTypes);
        }
        if (isEditableText) {
            node.setEditable(true);
        }
    }
}

